% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucket_trades.R
\name{bucket_trades}
\alias{bucket_trades}
\title{Bucketed trade data}
\usage{
bucket_trades(
  binSize = "1m",
  partial = "false",
  symbol = "XBTUSD",
  count = 1000,
  reverse = "true",
  filter = NULL,
  columns = NULL,
  start = NULL,
  startTime = NULL,
  endTime = NULL,
  use_auth = FALSE
)
}
\arguments{
\item{binSize}{character string.
The time interval to bucket by, must be one of: \code{"1m"}, \code{"5m"}, \code{"1h"} or \code{"1d"}.}

\item{partial}{character string. Either \code{"true"} of \code{"false"}.
If \code{"true"}, will send in-progress (incomplete) bins for the current time period.}

\item{symbol}{a character string for the instrument symbol.
Use \code{\link[=available_symbols]{available_symbols()}} to see available symbols.}

\item{count}{an optional integer to specify the number of rows to return.
Maximum of 1000 (the default) per request.}

\item{reverse}{an optional character string. Either \code{"true"} of \code{"false"}.
If \code{"true"}, result will be ordered with starting with the newest (defaults to \code{"true"}).}

\item{filter}{an optional character string for table filtering.
Send JSON key/value pairs, such as \code{"{'key':'value'}"}. See examples.}

\item{columns}{an optional character vector of column names to return.
If \code{NULL}, all columns will be returned.}

\item{start}{an optional integer. Can be used to specify the starting point for results.}

\item{startTime}{an optional character string.
Starting date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}

\item{endTime}{an optional character string.
Ending date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}

\item{use_auth}{logical. Use \code{TRUE} to enable authentication with API key.}
}
\value{
\code{bucket_trades()} returns a \code{data.frame} containing:
\itemize{
\item{timestamp: }{POSIXct. Date and time of trade.}
\item{symbol: }{character. Instrument ticker.}
\item{open: }{numeric. Opening price for the bucket.}
\item{high: }{numeric. Highest price in the bucket.}
\item{low: }{numeric. Lowest price in the bucket.}
\item{close: }{numeric. Closing price of the bucket.}
\item{trades: }{numeric. Number of trades executed within the bucket.}
\item{volume: }{numeric. Volume in USD.}
\item{vwap: }{numeric. Volume weighted average price.}
\item{lastSize: }{numeric. Size of the last trade executed.}
\item{turnover: }{numeric. How many satoshi were exchanged.}
\item{homeNotional: }{numeric. BTC value of the bucket.}
\item{foreignNotional: }{numeric. USD value of the bucket.}
}
}
\description{
\code{bucket_trades()} retrieves open high low close (OHLC) data for the specified symbol/time frame.
}
\details{
The API will only return 1000 rows per call. If the desired time frame requires more than one API call,
consider using \code{\link[=map_bucket_trades]{map_bucket_trades()}}.
}
\examples{
\donttest{

# Return most recent data for symbol `"ETHUSD"` for 1 hour buckets

bucket_trades(
  binSize = "1h",
  symbol = "ETHUSD",
  count = 10
)
}
}
\references{
url{https://www.bitmex.com/api/explorer/#!/Trade/Trade_getBucketed}
}
\concept{map_bucket_trades}
