% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_bucket_trades.R
\name{tn_map_bucket_trades}
\alias{tn_map_bucket_trades}
\title{Bucket trade data over an extended period (testnet)}
\usage{
tn_map_bucket_trades(
  start_date = "2015-09-25 13:00:00",
  end_date = now(tzone = "UTC"),
  binSize = "1d",
  symbol = "XBTUSD",
  partial = "false",
  filter = NULL,
  use_auth = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{start_date}{character string.
Starting date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}

\item{end_date}{character string.
Ending date for results in the format \code{"yyyy-mm-dd"} or \code{"yyyy-mm-dd hh-mm-ss"}.}

\item{binSize}{character string.
The time interval to bucket by, must be one of: \code{"1m"}, \code{"5m"}, \code{"1h"} or \code{"1d"}.}

\item{symbol}{a character string for the instrument symbol.
Use \code{\link[=available_symbols]{available_symbols()}} to see available symbols.}

\item{partial}{character string. Either \code{"true"} or \code{"false"}.
If \code{"true"}, will send in-progress (incomplete) bins for the current time period.}

\item{filter}{an optional character string for table filtering.
Send JSON key/value pairs, such as \code{"{'key':'value'}"}. See examples in \code{\link[=trades]{trades()}}.}

\item{use_auth}{logical. Use \code{TRUE} to enable authentication with API key.}

\item{verbose}{logical. If \code{TRUE}, will print information to the console. Useful for
long running requests.}
}
\description{
\code{tn_map_bucket_trades()} uses \code{purrr::map_dfr} to execute multiple API calls.
This is useful when the data you want to return exceeds the maximum 1000 row response limit,
but do not want to have to manually call \code{\link[=tn_bucket_trades]{tn_bucket_trades()}} repeatedly.
}
\examples{
\dontrun{
# Get hourly bucketed trade data between 2020-01-01 and 2020-02-01

tn_map_bucket_trades(
  start_date = "2020-01-01",
  end_date = "2020-02-01",
  binSize = "1h"
)
}
}
\references{
\url{https://testnet.bitmex.com/api/explorer/#!/Trade/Trade_getBucketed}
}
\seealso{
\code{\link[=map_bucket_trades]{map_bucket_trades()}} for more information.
}
