% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_expand.R
\name{bm_expand}
\alias{bm_expand}
\title{Expand bitmaps by repeating each row and/or column}
\usage{
bm_expand(bm_object, width = 1L, height = 1L)
}
\arguments{
\item{bm_object}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}},  or \code{\link[=bm_font]{bm_font()}} object.}

\item{width}{An integer of how many times to repeat each column.}

\item{height}{An integer of how many times to repeat each row.}
}
\value{
Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}}, or \code{\link[=bm_font]{bm_font()}} object.
}
\description{
\code{bm_expand()} expands bitmap(s) by repeating each row and/or column
an indicated number of times.
}
\examples{
 font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
 font <- read_hex(font_file)
 capital_r <- font[[str2ucp("R")]]
 print(capital_r, px = px_ascii)
 print(bm_expand(capital_r, width = 2L),
       px = px_ascii)
 print(bm_expand(capital_r, height = 2L),
       px = px_ascii)
 print(bm_expand(capital_r, width = 2L, height = 2L),
       px = px_ascii)
}
\seealso{
\code{\link[=bm_extend]{bm_extend()}} (and \code{\link[=bm_resize]{bm_resize()}} which makes larger bitmaps
by adding pixels to their sides.
}
