% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_email.R
\name{attach_connect_email}
\alias{attach_connect_email}
\title{Associate an email when publishing an R Markdown document to RStudio Connect}
\usage{
attach_connect_email(email = NULL, subject = NULL,
  attachments = NULL, attach_output = FALSE, text = NULL,
  preview = TRUE)
}
\arguments{
\item{email}{A rendered email message. Normally, we'd want to use an
associated .Rmd file with the \code{blastula::blastula_email} R Markdown output
format in \code{\link[=render_connect_email]{render_connect_email()}} call (where its \code{input} is the email
.Rmd file).}

\item{subject}{An option to specify the the email subject while attaching the
email object.}

\item{attachments}{A vector of attachments for the Connect email. These files
can be any of those deployed when publishing to RStudio Connect, and, any
generated files (via R Markdown rendering).}

\item{attach_output}{Should the rendered output of the main R Markdown
document be included as an email attachment? By default, this is \code{FALSE}.
If \code{TRUE} the main R Markdown document will be attached first (before any
files specified in \code{attachments}) and the filename will be preserved.}

\item{text}{Instead of using a rendered email document through the \code{email}
option, we can use plain text here. However, if any \code{email} object is
supplied then input to \code{text} is ignored.}

\item{preview}{Should the email message display it's own preview window? If
\code{TRUE} (the default), the rendered email message will be shown in the
default browser.}
}
\description{
This function is used to customize emails sent by RStudio Connect in
conjunction with publishing an R Markdown document. It associates a custom
email message with the main R Markdown document, which Connect can send to
selected recipients. The main input is a rendered email message, which can be
produced by either the \code{\link[=render_email]{render_email()}} or \code{\link[=render_connect_email]{render_connect_email()}} function.
}
\details{
Since this function needs to be invoked within an R Markdown document, the
chunk option \code{echo=FALSE} is useful here (so that viewers of the rendered
document don't have to unnecessarily read code related to email inclusion).
While the output is invisible, any errors related to rendering will be
visible to the author.
}
