% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creds_helpers.R
\name{credential_helpers}
\alias{credential_helpers}
\alias{creds}
\alias{creds_anonymous}
\alias{creds_envvar}
\alias{creds_key}
\alias{creds_file}
\title{Helpers for supplying SMTP credentials}
\usage{
creds(user = NULL, provider = NULL, host = NULL, port = NULL, use_ssl = TRUE)

creds_anonymous(provider = NULL, host = NULL, port = NULL, use_ssl = TRUE)

creds_envvar(
  user = NULL,
  pass_envvar = "SMTP_PASSWORD",
  provider = NULL,
  host = NULL,
  port = NULL,
  use_ssl = TRUE
)

creds_key(id)

creds_file(file)
}
\arguments{
\item{user}{The username for the email account. Typically, this is the email
address associated with the account.}

\item{provider}{An optional email provider shortname for autocompleting SMTP
configuration details (the \code{host}, \code{port}, \code{use_ssl} options). Options
currently include \code{gmail}, \code{outlook}, and \code{office365}. If nothing is
provided then values for \code{host}, \code{port}, and \code{use_ssl} are expected.}

\item{host, port, use_ssl}{Configuration info for the SMTP server. The \code{host}
and \code{port} parameters are the address and port for the SMTP server;
\code{use_ssl} is an option as to whether to use SSL: supply a \code{TRUE} or \code{FALSE}
value.}

\item{pass_envvar}{The name of the environment variable that holds the value
for an email account password. This is only used in the \code{\link[=creds_envvar]{creds_envvar()}}
credential helper function.}

\item{id}{When using the \code{\link[=creds_key]{creds_key()}} credential helper, the ID value of the
key (in the system key-value store) needs to be given here. This was
explicitly provided when using the \code{\link[=create_smtp_creds_key]{create_smtp_creds_key()}} function (with
its own \code{id} argument). To get an information table with all available
\pkg{blastula} keys in the key-value store, we can use the
\code{\link[=view_credential_keys]{view_credential_keys()}} function.}

\item{file}{When using the \code{\link[=creds_file]{creds_file()}} credential helper, we need to
specify the location of the credential file, and, this is where that is
done. The credential file was ideally generated by the
\code{\link[=create_smtp_creds_file]{create_smtp_creds_file()}} function.}
}
\value{
A credentials list object.
}
\description{
These helper functions, the credential helpers, are used to supply SMTP
configuration and authorization information for the \code{\link[=smtp_send]{smtp_send()}} function.
The \code{\link[=creds_file]{creds_file()}}, \code{\link[=creds_anonymous]{creds_anonymous()}}, \code{\link[=creds_key]{creds_key()}}, and \code{\link[=creds]{creds()}}
functions are to be used expressly with the \code{credentials} argument of
\code{\link[=smtp_send]{smtp_send()}}.
}
\details{
The \code{\link[=creds]{creds()}} credential helper allows for manual specification of SMTP
configuration and authentication.

The \code{\link[=creds_anonymous]{creds_anonymous()}} credential helper is similar to \code{\link[=creds]{creds()}} but
provides convenient defaults for authenticating anonymously with an SMTP
server.

The \code{\link[=creds_key]{creds_key()}} credential helper gets credentials stored in the
system-wide key-value store. We can set that key and the credentials data
using the \code{\link[=create_smtp_creds_key]{create_smtp_creds_key()}} function.

The \code{\link[=creds_file]{creds_file()}} credential helper is used to obtain credentials from a
file stored on disk. We can create that file using the
\code{\link[=create_smtp_creds_file]{create_smtp_creds_file()}} function.

The \code{\link[=creds_envvar]{creds_envvar()}} credential helper reads the password from the
\code{SMTP_PASSWORD} environment variable (or an environment variable name that
you specify). If using environment variables for other parameters, call
\code{\link[=Sys.getenv]{Sys.getenv()}} manually (e.g. \code{user = Sys.getenv("SMTP_USER")}).
}
