% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_statistics.R
\docType{class}
\name{ChiSquare-class}
\alias{ChiSquare-class}
\alias{ChiSquare}
\alias{setupChiSquare}
\title{Chi-squared test}
\usage{
setupChiSquare(
  alpha,
  beta,
  r = 1,
  delta,
  alternative = c("greater", "smaller"),
  n_max = Inf,
  ...
)
}
\arguments{
\item{alpha}{One-sided type I error rate.}

\item{beta}{Type II error rate.}

\item{r}{Allocation ratio between experimental and control group.}

\item{delta}{Difference of effect size between alternative and null hypothesis.}

\item{alternative}{Does the alternative hypothesis contain greater
(\code{greater}) or smaller (\code{smaller}) values than the
null hypothesis.}

\item{n_max}{Maximal overall sample size. If the recalculated sample size
is greater than \code{n_max} it is set to \code{n_max}.}

\item{...}{Further optional arguments.}
}
\value{
An object of class \code{\link{ChiSquare}}.
}
\description{
This class implements a chi-squared test for superiority trials. A trial
with binary outcomes in two groups \code{E} and \code{C} is assumed. If
\code{alternative == "greater"} the null and alternative hypotheses for the
difference in response probabilities are
\ifelse{html}{\out{<p>H<sub>0</sub>: p<sub>E</sub> &le; p<sub>C</sub>
vs. H<sub>1</sub>: p<sub>E</sub> > p<sub>C</sub>.</p>}}{\deqn{
H_0: p_E \leq p_C \textrm{ vs. } H_1: p_E > p_C.}}
If \code{alternative == "smaller"}, the direction of the effect is changed.

The function \code{setupChiSquare} creates an object of class
\code{\link{ChiSquare}}.
}
\details{
The nuisance parameter is the overall response probability
\ifelse{html}{\out{p<sub>0</sub>}}{\eqn{p_0}}. In the blinded sample size
recalculation procedure it is blindly estimated by:
\ifelse{html}{\out{<p>p<sub>0,est</sub> :=
(X<sub>1,E</sub> + X<sub>1,C</sub>) / (n<sub>1,E</sub> +
n<sub>1,C</sub>),</p>}}{\deqn{\hat{p}_0 :=
(X_{1,E} + X_{1,C}) / (n_{1,E} + n_{1,C}),}}
where \ifelse{html}{\out{X<sub>1,E</sub>}}{\eqn{X_{1,E}}} and
\ifelse{html}{\out{X<sub>1,C</sub>}}{\eqn{X_{1,C}}} are the numbers of
responses and \ifelse{html}{\out{n<sub>1,E</sub>}}{\eqn{n_{1,E}}} and
\ifelse{html}{\out{n<sub>1,C</sub>}}{\eqn{n_{1,C}}} are the sample sizes
of the respective group after the first stage. The event rates in both
groups under the alternative hypothesis can then be blindly estimated as:
\ifelse{html}{\out{<p>p<sub>C,A,est</sub> :=
p<sub>0,est</sub> - &Delta; * r / (1 + r),
p<sub>E,A,est</sub> := p<sub>0,est</sub> - &Delta; r / (1 + r),</p>}}{\deqn{
\hat{p}_{C,A} := \hat{p}_0 - \Delta \cdot r / (1 + r) \textrm{, }
\hat{p}_{E,A} := \hat{p}_0 + \Delta / (1 + r),}}
where \ifelse{html}{\out{&Delta;}}{\eqn{\Delta}} is the difference in
response probabilities under the alternative hypothesis and r is the
allocation ratio of the sample sizes in the two groups.
These blinded estimates can then be used to re-estimate the sample
size.

The following methods are available for this class:
\code{\link{toer}}, \code{\link{pow}}, \code{\link{n_dist}},
\code{\link{adjusted_alpha}}, and \code{\link{n_fix}}.
Check the design specific documentation for details.

For non-inferiority trials use the function \code{\link{setupFarringtonManning}}.
}
\examples{
design <- setupChiSquare(alpha = .025, beta = .2, r = 1, delta = 0.2,
alternative = "greater")

}
\references{
Friede, T., & Kieser, M. (2004). Sample size recalculation for binary data
in internal pilot study designs. Pharmaceutical Statistics:
The Journal of Applied Statistics in the Pharmaceutical Industry,
3(4), 269-279. \cr
Kieser, M. (2020). Methods and applications of sample size calculation and
recalculation in clinical trials. Springer.
}
