% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Auxiliary_and_graphics_functions.R
\name{dposterior}
\alias{dposterior}
\title{dposterior}
\usage{
dposterior(posterior_sample, data, theta = NULL)
}
\arguments{
\item{posterior_sample}{a list given by the \code{Bliss_Gibbs_Sampler} function.}

\item{data}{a list containing
\describe{
\item{y}{a numerical vector, the outcomes.}
\item{x}{a list of matrices, the qth matrix contains the observations of the
      qth functional covariate at time points given by \code{grids}.}
}}

\item{theta}{a matrix or a vector which contains the parameter set.}
}
\value{
Return the (log) posterior density, the (log) likelihood and the
        (log) prior density for the given parameter set.
}
\description{
Compute (non-normalized) posterior densities for a given parameter set.
}
\details{
If the \code{theta} is NULL, the posterior density is computed from
         the MCMC sample given in the \code{posterior_sample}.
}
\examples{
data(data1)
data(param1)
# result of res_bliss1<-fit_Bliss(data=data1,param=param1)
data(res_bliss1)
# Compute the posterior density of the MCMC sample :
res_poste <- dposterior(res_bliss1$posterior_sample,data1)
}
