% Generated by roxygen2 (4.0.2): do not edit by hand
\name{blocks}
\alias{blocks}
\title{Block designs}
\usage{
blocks(treatments, replicates, blocklevels = hcf, searches = min(64,
  floor(4096/nunits)), seed = NULL)
}
\arguments{
\item{treatments}{a list of numbers for the number of treatments in each treatment replication set of the design. Each treatment number must have a matching
replication number in the \code{replicates} list.}

\item{replicates}{a list of numbers for the number of replicates in each treatment replication set in the design. Each replication number must
have a matching treatment number in the \code{treatments} list.}

\item{blocklevels}{an optional list of nested blocks where the first number is the number of main blocks and where the  remaining numbers, if any,
are the numbers of blocks nested in each preceding block. The default is the hcf of the replication numbers which gives a maximum set of complete orthogonal main blocks.}

\item{searches}{an optional number for the number of local optima searched during optimization. The default is the minimum of 64 or the integer quotient of 4096
divided by the number of plots.}

\item{seed}{an integer seed for initializing the random number generator where a design must be reproducible. The default is a random seed.}
}
\value{
\item{Design}{Data frame showing the block and treatment factors for each sub-plot}
\item{Plan}{Data frame showing the allocation of treatments to sub-plots for each block in the design}
\item{Incidences}{List of blocks-by-treatments incidence matrices, one for each stratum in the design}
\item{Efficiencies}{Data frame showing the A-efficiency factor for each stratum in the design together with an upper bound, where available}
\item{seed}{Numerical seed for random number generator}
}
\description{
Constructs nested block designs for unstructured treatments with arbitrary replication, not necessarily all equal, and arbitrary depth of nesting.
}
\details{
The \code{blocks} function constructs optimized nested block designs for unstructured treatment sets where treatments can have any arbitrary replication, not necessarily all equal,
and blocks can have any feasible depth of nesting.

The treatments are defined by the \code{treatments} and \code{replicates} parameter lists where the \code{treatments} list partitions the
total number of treatments into sub-sets of equally replicated treatments and the \code{replicates} list provides the replication for each set. The two lists are of equal length and
the treatment numbers and replication numbers are paired according to their index position in the two lists. Any feasible number of replication levels can be defined and the resulting treatments are
labelled consecutively according to the ordering of the the treatment sets in the two lists.

The \code{blocklevels} list defines the blocks structure of the design where the first number in the list is the number of main blocks
and the succesive numbers, if any, are the numbers of succesively nested blocks. The numbers are the nested blocks in each preceding block therefore the cumulative product of the numbers
is the total number of blocks in the design. The default value for the \code{blocklevels} list is a single number equal to the highest common factor (hcf) of
the replication numbers, which gives an orthogonal complete blocks design with the maximum possible number of othogonal blocks.

Block sizes in any given stratum are equal if the cumulative number of blocks in that stratum exactly divides the total number of plots, otherwise they differ by not more than a single unit.

Designs with t = v**2 equally replicated treatments, k = v+1 or fewer replicates and blocks of size v where v is a prime or prime-power if k>3 or is arbitrary otherwise,
are regular lattice designs and can be constructed algebraically. \code{blocks} constructs all regular lattice designs algebraically and also constructs the special
non-prime lattice with t = 100, v = 10 and k< = 4 algebraically. Prime-power lattice designs require the \code{MOLS} function of the \code{crossdes} package.
All other designs are constructed algorithmically by a swapping algorithm that maximizes the determinant of the information matrix (D-optimality).

Designs are fully randomized with each set of nested blocks randomized within the preceding set of blocks and with treatments fully randomized within the bottom set of blocks.
}
\examples{
# 3 treatments with 2 reps, 2 treatments with 4 reps, 4 treatments with 3 reps
# the hcf of the replication numbers is 1 and the default design is a completely randomized design
blocks(treatments=c(3,2,4),replicates=c(2,4,3))

# 50 treatments with 4 reps in 4 complete randomized blocks
blocks(treatments=50,replicates=4)

# as above but with 4 main blocks and 5 nested blocks within each main block
blocks(treatments=50,replicates=4,blocklevels=c(4,5))

# as above but with 20 additional single replicate treatments, one to each block
blocks(treatments=c(50,20),replicates=c(4,1),blocklevels=c(4,5))

# 64 treatments with 2 reps and 2 main blocks with five 2-level nested factors
blocks(treatments=64,replicates=2,blocklevels=c(2,2,2,2,2,2),searches=4)

# concurrence matrices of 36 treatments with 3 reps and 3 main blocks with 6 nested blocks
crossprod(blocks(treatments=36,replicates=3,blocklevels=c(3,6))$Incidences[[2]])

# concurrence matrix for 13 treatments with 4 reps and 13 treatments with one rep in 13 blocks
crossprod(blocks(c(13,13),c(4,1),13,searches=100)$Incidences[[1]])
}
\references{
Sailer, M. O. (2013). crossdes: Construction of Crossover Designs. R package version 1.1-1. http://CRAN.R-project.org/package=crossdes
}

