% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks.r
\name{blocks}
\alias{blocks}
\title{Block designs for unstructured treatment sets}
\usage{
blocks(treatments, replicates, blocks = NULL, searches = NULL,
  seed = NULL, jumps = 1)
}
\arguments{
\item{treatments}{a partition of the total required number of treatments into equally replicated treatment sets, possibly a complete
partition into individual treatments.}

\item{replicates}{a set of treatment replication numbers with one replication number for each partitioned treatment set, possibly a 
complete set of treatment replication numbers.}

\item{blocks}{the number of blocks nested in each preceding block for each level of nesting from the top-level block downwards.}

\item{searches}{the maximum number of local optima searched for a design optimization. The default number decreases
as the design size increases.}

\item{seed}{an integer initializing the random number generator. The default is a random seed.}

\item{jumps}{the number of pairwise random treatment swaps used to escape a local maxima. The default is a single swap.}
}
\value{
\item{Treatments}{A table showing the replication number of each treatment in the design.}
\item{Design}{Data frame giving the optimized block and treatment design in plot order.}
\item{Plan}{Data frame showing a plan view of the treatment design in the bottom level of the design.}
\item{blocks_model}{The D-efficiencies and the A-efficiencies of the blocks in each nested level of the 
 design together with A-efficiency upper-bounds, where available.}
\item{seed}{Numerical seed used for random number generator.}
\item{searches}{Maximum number of searches used for each level.}
\item{jumps}{Number of random treatment swaps used to escape a local maxima.}
}
\description{
Constructs randomized nested block designs for unstructured treatment sets with any feasible depth of nesting.
}
\details{
Constructs randomized nested block designs with arbitrary depth of nesting for arbitrary unstructured treatment sets.

The \code{treatments} parameter is a set of numbers that partitions the total number of treatments into equally 
replicated treatment sets while the \code{replicates} parameter is a matching set of numbers that defines the 
replication of each equally replicated treatment set.

The \code{blocks} parameter, if any, defines the number of blocks for each level of nesting from the highest
to the lowest. The first number, if any, is the number of nested row blocks in the first-level of nesting, 
the second number, if any, is the number of nested row blocks in
the second-level of nesting and so on down to any required feasible depth of nesting.

Block sizes are as nearly equal as possible and will never differ by more than a single plot for any 
particular block classification. 

Unreplicated treatments are allowed and any simple nested block design can be augmented by any number 
of single unreplicated treatments to give augmented blocks that never differ in size by more than a single plot.
However, it may sometimes be preferable to find an efficient 
block design for the replicated treatments and then add the unreplicated treatments to the design heuristically. 

Square lattice designs are resolvable incomplete block designs for r replicates of p*p treatments 
arranged in blocks of size p where r < p+2 for prime or prime power p or r < 4 for general p. 
Square lattice designs are constructed algebraically from Latin squares or MOLS.

Rectangular lattice designs are resolvable incomplete block designs for r replicates of (p-1)*p treatments 
arranged in blocks of size p-1 where r < p+1 for prime or prime power p. Rectangular lattice designs 
are constructed algebraically from Latin squares or MOLS.

Designs based on prime-power MOLS require the \code{\link[crossdes]{MOLS}} package.

All other designs are constructed numerically by optimizing a D-optimality criterion.

Outputs:

\itemize{
\item  A data frame showing the allocation of treatments to blocks with successive nested strata arranged in standard block order.\cr
\item  A table showing the replication number of each treatment in the design. \cr
\item  A table showing the block levels and the achieved D-efficiency and A-efficiency factor for each nested level together
  with A-efficiency upper bounds, where available. \cr
\item  A plan showing the allocation of treatments to blocks in the bottom level of the design.\cr
}
}
\examples{

## The number of searches in the following examples have been limited for fast execution.  
## In practice, the number of searches may need to be increased for optimum results.
## Designs should be rebuilt several times to check that a near-optimum design has been found.  

# 12 treatments x 4 replicates in 4 complete blocks with 4 sub-blocks of size 3
# rectangular lattice see Plan 10.10 Cochran and Cox 1957.
blocks(treatments=12,replicates=4,blocks=c(4,4))

# 3 treatments x 2 replicates + 2 treatments x 4 replicates in two complete randomized blocks
blocks(treatments=c(3,2),replicates=c(2,4),searches=10)

# 50 treatments x 4 replicates with 4 main blocks and 5 nested sub-blocks in each main block
blocks(treatments=50,replicates=4,blocks=c(4,5))

# as above but with 20 additional single replicate treatments, one single treatment per sub-block
blocks(treatments=c(50,20),replicates=c(4,1),blocks=c(4,5))

# 6 replicates of 6 treatments in 4 blocks of size 9 (non-binary block design)
blocks(treatments=6,replicates=6,blocks=4)

# 128 treatments x 2 replicates with two main blocks and 3 levels of nesting
 \donttest{blocks(128,2,c(2,2,2,2))}

#' # 64 treatments x 4 replicates with 4 main blocks nested blocks of size 8 (lattice square)
blocks(64,4,c(4,8)) 

# 100 treatments x 4 replicates with 4 main blocks nested blocks of size 10 (lattice square)
blocks(100,4,c(4,10)) 

}
\references{
Sailer, M. O. (2013). crossdes: Construction of Crossover Designs. R package version 1.1-1. 
https://CRAN.R-project.org/package=crossdes

Cochran, W.G., and G.M. Cox. 1957. Experimental Designs, 2nd ed., Wiley, New York.
}
