% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-pairs.R
\name{blr_pairs}
\alias{blr_pairs}
\title{Concordant & discordant pairs}
\usage{
blr_pairs(model)
}
\arguments{
\item{model}{An object of class \code{glm}.}
}
\value{
A tibble.
}
\description{
Association of predicted probabilities and observed responses.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
family = binomial(link = 'logit'))

blr_pairs(model)

}
\references{
\url{https://doi.org/10.1080/10485259808832744}

\url{https://doi.org/10.1177/1536867X0600600302}
}
\seealso{
Other model fit statistics: 
\code{\link{blr_model_fit_stats}()},
\code{\link{blr_multi_model_fit_stats}()},
\code{\link{blr_rsq_adj_count}()},
\code{\link{blr_rsq_cox_snell}()},
\code{\link{blr_rsq_effron}()},
\code{\link{blr_rsq_mcfadden_adj}()},
\code{\link{blr_rsq_mckelvey_zavoina}()},
\code{\link{blr_rsq_nagelkerke}()},
\code{\link{blr_test_lr}()}
}
\concept{model fit statistics}
