% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-hosmer-lemeshow-test.R
\name{blr_test_hosmer_lemeshow}
\alias{blr_test_hosmer_lemeshow}
\title{Hosmer lemeshow test}
\usage{
blr_test_hosmer_lemeshow(model, data = NULL)
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{data}{a \code{tibble} or \code{data.frame}.}
}
\description{
Hosmer lemeshow goodness of fit test.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
             family = binomial(link = 'logit'))

blr_test_hosmer_lemeshow(model)

}
\references{
Hosmer,  D.W.,  Jr.,  &  Lemeshow,  S.  (2000), Applied  logistic  regression(2nd  ed.).
New  York:  John Wiley & Sons.
}
\seealso{
Other model validation techniques: 
\code{\link{blr_confusion_matrix}()},
\code{\link{blr_decile_capture_rate}()},
\code{\link{blr_decile_lift_chart}()},
\code{\link{blr_gains_table}()},
\code{\link{blr_gini_index}()},
\code{\link{blr_ks_chart}()},
\code{\link{blr_lorenz_curve}()},
\code{\link{blr_roc_curve}()}
}
\concept{model validation techniques}
