% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_convex.R
\name{softmaxLoss}
\alias{softmaxLoss}
\title{softmax Loss Function}
\usage{
softmaxLoss(x, y, loss.weights = 1)
}
\arguments{
\item{x}{instance matrix, where x(t,) defines the features of instance t}

\item{y}{target matrix where y(t,) is a probability distribution that should sum to 1}

\item{loss.weights}{numeric vector of loss weights to incure for each instance of x. 
Vector length should match nrow(y), but values are recycled if not of identical size.}
}
\value{
a function taking one argument w and computing the loss value and the gradient at point w
}
\description{
softmax loss function may be used to predict probability distributions
}
\examples{
  # -- Load the data
  x <- cbind(intercept=100,data.matrix(iris[1:4]))
  y <- model.matrix(~iris$Species+0)
  w <- nrbm(softmaxLoss(x,y))
  P <- predict(w,x)
  table(max.col(P),iris$Species)
}
\references{
Teo et al.
  Bundle Methods for Regularized Risk Minimization
  JMLR 2010
}
