% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{bmstdr_variogram}
\alias{bmstdr_variogram}
\title{Calculates and plots the variogram cloud and an estimated variogram.}
\usage{
bmstdr_variogram(
  formula = yo3 ~ utmx + utmy,
  coordtype = "utm",
  data = nyspatial,
  nbins = 30
)
}
\arguments{
\item{formula}{Its a formula argument for the response and the coordinates.}

\item{coordtype}{Type of coordinates: utm, lonlat or plain with utm 
(supplied in meters) as the default. Distance will be calculated in units of kilometer
if this argument is either utm or lonlat. Euclidean distance will be calculated 
if this is given as the third type plain.  If  distance in meter is to be calculated 
then coordtype should be passed on as plain although the coords are supplied in UTM.}

\item{data}{A data frame containing the response and the co-ordinates}

\item{nbins}{Number of bins for the variogram. Default is 30.}
}
\value{
A list containing:
  \itemize{
   \item cloud - A data frame containing the variogram cloud. 
   This contains pairs of all the data locations, distance 
   between the locations and the variogram value for the pair. 
   \item variogram  A data frame containing the variogram values in 
   each bin.   
   \item cloudplot A ggplot2 object of the plot of the  variogram cloud. 
   \item variogramplot A ggplot2 object of the plot of the  binned variogram
    values. 
    }
}
\description{
Calculates and plots the variogram cloud and an estimated variogram.
}
\examples{
a <- bmstdr_variogram(data=nyspatial, formula = yo3~utmx + utmy, 
coordtype="utm", nb=50)
names(a)
library(ggpubr)
ggarrange(a$cloudplot, a$variogramplot, legend = "none", nrow = 1, ncol = 2)
}
