% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engdata.R
\docType{data}
\name{engtotals}
\alias{engtotals}
\title{Total number of weekly Covid-19 deaths and cases in the 313 local 
Local Authority Districts, Counties  and Unitary Authorities (LADCUA) in 
England during the first peak from March 13 to July 31, 2020.}
\format{
An object of class \code{data.frame} with 313 rows and 19 columns.
}
\source{
\insertCite{SahuBohning2021;textual}{bmstdr}. 
 @format A data frame with 313 rows and 19 columns:
\describe{
  \item{Areacode}{Areacode identifier of the 313 
  Local Authority Districts, Counties  and Unitary Authorities (LADCUA)}
  \item{mapid}{A numeric column identifying the map area needed for plotting}
  \item{spaceid}{A numeric variable taking value 1 to 313 identifying the LADCUA's}
  \item{Region}{Identifies one of the 9 English regions}
  \item{popn}{Population number in mid-2019}
  \item{jsa}{Percentage of the working age  population receiving job-seekers allowance 
   during January 2020}
  \item{houseprice}{Median house price  in March 2020}
  \item{popdensity}{Population density in mid-2019}    
  \item{startdate}{Start date of the week}
  \item{Weeknumber}{Week numbers 11 to 30}
  \item{no2}{Estimated average value of NO2 at the centroid of the LADCUA in that week}
  \item{covid}{Number of Covid-19 deaths within 28 days of a positive test}
  \item{allcause}{Total number deaths}
  \item{noofcases}{Total number of cases}
  \item{Edeaths}{Expected number of Covid-19 deaths. See Sahu and 
  Bohning (2021) for methodology.} 
  \item{Ecases}{Expected number of cases.} 
  \item{logEdeaths}{Log of the column \code{Edeaths}}
  \item{logEcases}{Log of the column \code{Ecases}}
  \item{casesmr}{Standaridised morbidity rate for the number of cases, 
  \code{noofcases}/\code{Ecases}}
  \item{nweek}{Number of weeks during March 13 to July 31, 2020. All values are 20.}
  \item{noofhighweeks}{Number of  weeks out of 20 when the \code{casesmr} 
     was greater than 1}      
}
}
\usage{
engtotals
}
\description{
Total number of weekly Covid-19 deaths and cases in the 313 local 
Local Authority Districts, Counties  and Unitary Authorities (LADCUA) in 
England during the first peak from March 13 to July 31, 2020.
}
\examples{
 colnames(engtotals)
 dim(engtotals)
 summary(engtotals[, 5:14])
}
\references{
\insertAllCited{}
}
\keyword{datasets}
