% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/0bnclassify-doc.R, R/learn-struct.R
\name{tan_chowliu}
\alias{tan_chowliu}
\alias{tan_cl}
\title{Learns a tree augmented naive Bayes classifier (TAN).}
\usage{
tan_cl(class, dataset, score = "loglik", blacklist = NULL, root = NULL)
}
\arguments{
\item{class}{A character. Name of the class variable.}

\item{dataset}{The data frame from which to learn the classifier.}

\item{score}{A character. The score to be maximized. \code{'loglik'},
  \code{'bic'}, and \code{'aic'} return the maximum likelihood, maximum BIC
  and maximum AIC tree/forest, respectively.}

\item{blacklist}{A character matrix. Edges that may be blacklisted from the
resulting structure. Note: currently ignored.}

\item{root}{A character. The feature to be used as root of the augmenting
tree. Only one feature can be supplied, even in case of an augmenting
forest. This argument is optional.}
}
\description{
Learns a one-dependence Bayesian classifier using Chow-Liu's algorithm. The
structure is learned so that either likelihood, the BIC or AIC scores are
maximized; the first option corresponds to the well-known tree augmented
naive Bayes (Friedman et al., 1997).
}
\details{
Edges with negative BIC or AIC weights are blacklisted from the final
structure. The structure thus might be a forest rather than a tree.
}
\references{
Friedman N, Geiger D and Goldszmidt M (1997). Bayesian network
  classifiers. \emph{Machine Learning}, \bold{29}, pp. 131--163.
}

