% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0bnclassify-doc.R, R/learn-struct.R
\name{greedy_wrapper}
\alias{greedy_wrapper}
\alias{fssj}
\alias{bsej}
\alias{tan_hc}
\alias{tan_hcsp}
\title{Learn Bayesian network classifiers in a a greedy wrapper fashion.}
\usage{
fssj(class, dataset, k, epsilon = 0.01, smooth = 0, cache_reset = NULL)

bsej(class, dataset, k, epsilon = 0.01, smooth = 0, cache_reset = NULL)

tan_hc(class, dataset, k, epsilon = 0.01, smooth = 0, cache_reset = NULL)

tan_hcsp(class, dataset, k, epsilon = 0.01, smooth = 0,
  cache_reset = NULL)
}
\arguments{
\item{class}{A character. Name of the class variable.}

\item{dataset}{The data frame from which to learn the classifier.}

\item{k}{An integer. The number of folds.}

\item{epsilon}{A numeric. Minimum absolute improvement in accuracy required 
to keep searching.}

\item{smooth}{A numeric. The smoothing value (\eqn{\alpha}) for Bayesian 
parameter estimation. Nonnegative.}

\item{cache_reset}{A numeric. Number of iterations after which to reset the 
cache of conditional probability tables. A small number reduces the amount
of memory used. \code{NULL} means the cache is never reset (the default).}
}
\value{
A \code{\link{bnc_dag}} object.
}
\description{
Greedy wrapper algorithms for learning Bayesian network classifiers. All 
algorithms use cross-validated estimate of predictive accuracy to evaluate 
candidate structures.
}
\examples{
data(car)
tanhc <- tan_hc('class', car, k = 5, epsilon = 0)  
plot(tanhc) 
  
}
\references{
Pazzani M (1996). Constructive induction of Cartesian product 
  attributes. In \emph{Proceedings of the Information, Statistics and 
  Induction in Science Conference (ISIS-1996)}, pp. 66-77
  
  Koegh E and Pazzani M (2002).Learning the structure of augmented Bayesian 
  classifiers. In \emph{International Journal on Artificial Intelligence 
  Tools}, \bold{11}(4), pp. 587-601.
}
