% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0bnclassify-doc.R, R/anb-bn-operate.R
\name{loglik}
\alias{loglik}
\alias{AIC.bnc_bn}
\alias{BIC.bnc_bn}
\alias{logLik.bnc_bn}
\title{Compute (penalized) log-likelihood.}
\usage{
\method{AIC}{bnc_bn}(object, ...)

\method{BIC}{bnc_bn}(object, ...)

\method{logLik}{bnc_bn}(object, ...)
}
\arguments{
\item{object}{A \code{\link{bnc_bn}} object.}

\item{...}{A data frame (\eqn{\mathcal{D}}{D}).}
}
\description{
Compute (penalized) log-likelihood score of a \code{\link{bnc_bn}} object on
a data set. Requires a data frame argument in addition to \code{object}.
}
\details{
log-likelihood =  \eqn{log P(\mathcal{D} \mid \theta)}{log P(D | \theta)},

Akaike's information criterion (AIC) = \eqn{log P(\mathcal{D} \mid \theta) - 
\frac{1}{2} |\theta|}{log P(D | \theta) - |\theta| / 2},

The Bayesian information criterion (BIC) score: = \eqn{log P(\mathcal{D} \mid
\theta) - \frac{\log N}{2} |\theta|}{log P(D | \theta) - N |\theta| / 2},

where \eqn{|\theta|} is the number of free parameters in \code{object}, 
\eqn{\mathcal{D}}{D} is the data set and N is the number of instances in 
\eqn{\mathcal{D}}{D}.
}
\examples{
data(car)
nb <- bnc('nb', 'class', car, smooth = 1)
logLik(nb, car)   
AIC(nb, car)
BIC(nb, car)
}
