% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cv}
\alias{cv}
\title{Estimate predictive accuracy with stratified cross validation.}
\usage{
cv(x, dataset, k, dag = TRUE, mean = TRUE)
}
\arguments{
\item{x}{List of \code{\link{bnc_bn}} or a single 
\code{\link{bnc_bn}}. The classifiers to evaluate.}

\item{dataset}{The data frame on which to evaluate the classifiers.}

\item{k}{An integer. The number of folds.}

\item{dag}{A logical. Whether to learn structure on each training subsample. 
Parameters are always learned.}

\item{mean}{A logical. Whether to return mean accuracy for each classifier or
to return a k-row matrix with accuracies per fold.}
}
\value{
A numeric vector of same length as \code{x}, giving the predictive
  accuracy of each classifier. If \code{mean = FALSE} then a matrix with k
  rows and a column per each classifier in \code{x}.
}
\description{
Estimate predictive accuracy of a classifier with stratified cross 
validation. It learns the models from the training subsamples by repeating 
the learning procedures used to obtain \code{x}. It can keep the network 
structure fixed and re-learn only the parameters, or re-learn both structure 
and parameters.
}
\examples{
data(car)
nb <- bnc('nb', 'class', car, smooth = 1) 
# CV a single classifier
cv(nb, car, k = 10) 
nb_manb <- bnc('nb', 'class', car, smooth = 1, manb_prior = 0.5) 
cv(list(nb=nb, manb=nb_manb), car, k = 10)
# Get accuracies on each fold
cv(list(nb=nb, manb=nb_manb), car, k = 10, mean = FALSE)
ode <- bnc('tan_cl', 'class', car, smooth = 1, dag_args = list(score = 'aic')) 
# keep structure fixed accross training subsamples
cv(ode, car, k = 10, dag = FALSE)
}
