% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensquery.R
\name{sensquery}
\alias{sensquery}
\title{Sensitivity of probability query}
\usage{
sensquery(
  bnfit,
  interest_node,
  interest_node_value,
  new_value,
  evidence_nodes = NULL,
  evidence_states = NULL
)
}
\arguments{
\item{bnfit}{object of class \code{bn.fit}.}

\item{interest_node}{character string. Node of the probability query of interest.}

\item{interest_node_value}{character string. Level of \code{interest_node}.}

\item{new_value}{numeric value between 0 and 1. New value of the probability of interest.}

\item{evidence_nodes}{character string. Evidence nodes. Set by default to \code{NULL}.}

\item{evidence_states}{character string. Levels of \code{evidence_nodes}. If \code{NULL} no evidence is considered. If \code{evidence_nodes="NULL"}, \code{evidence_states} should be set to \code{NULL}. Set by default to \code{NULL}.}
}
\value{
A dataframe with the following columns: \code{node} - the vertex of the proposed change; \code{Value node} - the level of \code{node} to be changed; \code{Value parents} - the levels of the parent variables of \code{node}; \code{Original value} - the original probability defined by \code{Node}, \code{Value node} and \code{Value parents}; \code{Suggested change} - the new proposed value for the probability defined by \code{Node}, \code{Value node} and \code{Value parents}; \code{CD distance} - the CD distance between the original and new network with the \code{Suggested change}.
}
\description{
\code{sensquery} returns, for a given change in a probability of interest, the parameters' changes to achieve it together with the corresponding CD distances.
}
\details{
The Bayesian network should be expressed as a \code{bn.fit} object.
The name of the node of the probability of interest, its level and the new value should be specified. Evidence could be also indicated.
The probability of interest is specified as follows:

 P ( \code{interest_node} = \code{interest_node_value} | \code{evidence_nodes} = \code{evidence_states}  ) = \code{new_value}

Only the  proportional co-variation scheme is used.
}
\examples{
sensquery(synthetic_bn,"y3", "3", 0.3)

}
\references{
Chan, H., & Darwiche, A. (2002). When do numbers really matter?. Journal of Artificial Intelligence Research, 17, 265-287.
}
\seealso{
\code{\link{sensitivity}}
}
