% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_node_monitor.R
\name{seq_node_monitor}
\alias{seq_node_monitor}
\alias{seq_marg_monitor}
\alias{seq_cond_monitor}
\title{Sequential node monitors}
\usage{
seq_marg_monitor(dag, df, node.name)

seq_cond_monitor(dag, df, node.name)
}
\arguments{
\item{dag}{an object of class \code{bn} from the \code{bnlearn} package}

\item{df}{a base R style dataframe}

\item{node.name}{node over which to compute the monitor}
}
\value{
A vector including the scores \eqn{Z_{ij}}, either marginal or conditional.
}
\description{
Sequential marginal and conditional node monitors for a vertex of a Bayesian network.
}
\details{
Consider a Bayesian network over variables \eqn{Y_1,\dots,Y_m} and suppose a dataset \eqn{(\boldsymbol{y}_1,\dots,\boldsymbol{y}_n)} has been observed, where \eqn{\boldsymbol{y}_i=(y_{i1},\dots,y_{im})} and \eqn{y_{ij}} is the i-th observation of the j-th variable.
Let \eqn{p_i} denote the marginal density of \eqn{Y_j} after the first \eqn{i-1} observations have been processed. Define
\deqn{E_i = \sum_{k=1}^Kp_i(d_k)\log(p_i(d_k)),}
\deqn{V_i = \sum_{k=1}^K p_i(d_k)\log^2(p_i(d_k))-E_i^2,}
where \eqn{(d_1,\dots,d_K)} are the possible values of \eqn{Y_j}. The sequential marginal node monitor for the vertex \eqn{Y_j} is defined as
\deqn{Z_{ij}=\frac{-\sum_{k=1}^i\log(p_k(y_{kj}))-\sum_{k=1}^i E_k}{\sqrt{\sum_{k=1}^iV_k}}.}
Values of \eqn{Z_{ij}} such that \eqn{|Z_{ij}|> 1.96} can give an indication of a poor model fit for the vertex \eqn{Y_j} after the first i-1 observations have been processed.

The sequential conditional node monitor for the vertex \eqn{Y_j} is defined as
 \deqn{Z_{ij}=\frac{-\sum_{k=1}^i\log(p_k(y_{kj}|y_{k1},\dots,y_{k(j-1)},y_{k(j+1)},\dots,y_{km}))-\sum_{k=1}^i E_k}{\sqrt{\sum_{k=1}^iV_k}},}
 where \eqn{E_k} and \eqn{V_k} are computed with respect to \eqn{p_k(y_{kj}|y_{k1},\dots,y_{k(j-1)},y_{k(j+1)},\dots,y_{km})}. Again, values of \eqn{Z_{ij}} such that \eqn{|Z_{ij}|> 1.96} can give an indication of a poor model fit for the vertex \eqn{Y_j}.
}
\examples{
seq_marg_monitor(chds_bn, chds[1:100,], "Events")
seq_marg_monitor(chds_bn, chds[1:100,], "Admission")

}
\references{
Cowell, R. G., Dawid, P., Lauritzen, S. L., & Spiegelhalter, D. J. (2006). Probabilistic networks and expert systems: Exact computational methods for Bayesian networks. Springer Science & Business Media.

Cowell, R. G., Verrall, R. J., & Yoon, Y. K. (2007). Modeling operational risk with Bayesian networks. Journal of Risk and Insurance, 74(4), 795-827.
}
\seealso{
\code{\link{influential_obs}}, \code{\link{node_monitor}}, \code{\link{seq_node_monitor}}, \code{\link{seq_pa_ch_monitor}}
}
