% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbnpsd.R
\name{rbnpsd}
\alias{rbnpsd}
\title{Simulate random allele frequencies and genotypes from the BN-PSD admixture model}
\usage{
rbnpsd(Q, F, m, wantX = TRUE, wantP = TRUE, wantB = TRUE, wantPa = TRUE,
  lowMem = FALSE, verbose = FALSE)
}
\arguments{
\item{Q}{The \eqn{n \times k}{n-by-k} matrix of admixture proportions}

\item{F}{The length-\eqn{k} vector of intermediate subpopulation \eqn{F_{ST}}{FST} values}

\item{m}{The number of loci to draw}

\item{wantX}{If TRUE (default), calculates and includes the random genotype matrix in the return list}

\item{wantP}{If TRUE (default), includes the random IAF matrix in the return list}

\item{wantB}{If TRUE (default), includes the random intermediate pop allele freq matrix in the return list}

\item{wantPa}{If TRUE (default), includes the random ancestral allele freq matrix in the return list}

\item{lowMem}{If TRUE, uses a low-memory algorithm to raw genotypes without storing or returning the corresponding IAF matrix.}

\item{verbose}{If TRUE, prints messages for every stage in the algorithm}
}
\value{
A named list that includes the following random matrices: X=genotypes, P=IAFs, B=intermediate pop allele freqs, Pa=vector of ancestral allele frequencies.  Items may be omitted depending on the values of wantX, wantP, wantB, or wantPa above.
}
\description{
This function returns simulated ancestral, intermediate, and individual-specific allele frequencies and genotypes given the admixture structure, as determined by the admixture proportions and the vector of intermediate subpopulation \eqn{F_{ST}}{FST} values.
The function is a wrapper around \code{\link{rpanc}}, \code{\link{rpint}}, \code{\link{rpiaf}}, and \code{\link{rgeno}}.
Below \eqn{m} is the number of loci, \eqn{n} is the number of individuals, and \eqn{k} is the number of intermediate subpopulations.
}
\examples{
# dimensions
m <- 10 # number of loci
n <- 5 # number of individuals
k <- 2 # number of intermediate subpops

# define population structure
F <- c(0.1, 0.3) # FST values for k=2 subpopulations
sigma <- 1 # dispersion parameter of intermediate subpops
Q <- q1d(n, k, sigma) # admixture proportions from 1D geography

# draw all random allele freqs and genotypes
out <- rbnpsd(Q, F, m)
X <- out$X # genotypes
P <- out$P # IAFs
B <- out$B # Intermediate AFs
pAnc <- out$Pa # Ancestral AFs

}
