% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aoi.R
\name{aoi}
\alias{aoi}
\title{Build area of interest (A.O.I.)}
\usage{
aoi(msk, mskSub = NULL, xy = FALSE, bbox = NULL)
}
\arguments{
\item{msk}{a character (path to raster or vector file), or a bounding box as numeric (xmin,xmax,ymin,ymax), 
or one or more (as list of) rasters of class "RasterLayer", or a single object of class "sf" or "SpatialPolygonsDataFrame". 
The reference data (raster or vector) to be used as mask. All model outputs will have the same extent (outline) as this object. 
All locations with no data (i.e. NA) cells in \code{msk} input will be ignored as well.}

\item{mskSub}{vector of values, for raster data only. The subset values from \code{msk} which should be considered to build the area 
of interest. All other values will be ignored and masked out during modelling.}

\item{xy}{logical. Should return a two column matrix of x and y coordinates of cells centre (raster data) or
the IDs of features? Defaults to FALSE, returning an object of class RasterLayer or sf.}

\item{bbox}{numeric of four elements, the coordinates defining a rectangle (bounding box) to limit the area of interest. 
Must be ordered as xmin, xmax, ymin, ymax. Coordinates must be in the same reference system as spatial data.}
}
\value{
An object of class RasterLayer  or sf, or a matrix of coordinates of mask cells (raster only). In the former case, valid cells 
(i.e. the area of interest) will have value 1, \code{NA} otherwise.
}
\description{
This function creates a spatial object (raster or vector) defining the area of interest, by taking a bounding box or 
a spatial object, or unioning the input spatial objects if more than one are provided.
When \code{msk} is a list of rasters, extent is set equal to their combined extent (union) and resolution 
to the finest resolution among them.
}
\details{
If rasters are used, all model outputs will have the same resolution and same extent as inherited from \code{msk}. 
All locations with no data (i.e. NA) cells from \code{msk} will be ignored as well.
}
\examples{
## Make a mask from a group of input layers:
list2env(ConwyData, environment())

network <- LandUseChange
spatialData <- c(ConwyLU, ConwySlope, ConwyStatus)
m <- aoi(spatialData)
m

## Plot mask
library(raster)
m <- aoi(ConwyLU)
plot(m)

## Make mask from a subset of values and plot
m <- aoi(ConwyLU, mskSub=c(2,3))
plot(m)

## Return coordinates of valid mask locations
coord <- aoi(ConwyLU, xy=TRUE)
head(coord)

## Using a bounding box
aoi(ConwyLU, bbox=c(270000, 284950, 347000, 365000))

## For vectorial spatial data. Note xy=TRUE shall return the features IDs
Conwy = sf::st_read(system.file("extdata", "Conwy.shp", package = "bnspatial"))
aoi(Conwy, bbox=c(270000, 284950, 347000, 365000))

}
\seealso{
\code{\link{extractByMask}}
}
