% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/learn-methods.R
\docType{methods}
\name{learn.params}
\alias{learn.params}
\alias{learn.params,BN,BNDataset}
\alias{learn.params,BN,BNDataset-method}
\title{learn the parameters of a \link{BN}.}
\usage{
learn.params(bn, dataset, ess = 1, use.imputed.data = F)

\S4method{learn.params}{BN,BNDataset}(bn, dataset, ess = 1,
  use.imputed.data = FALSE)
}
\arguments{
\item{bn}{a \code{\link{BN}} object.}

\item{dataset}{a \code{\link{BNDataset}} object.}

\item{ess}{Equivalent Sample Size value.}

\item{use.imputed.data}{use imputed data.}
}
\value{
new \code{\link{BN}} object with conditional probabilities.
}
\description{
Learn the parameters of a \link{BN} object according to a \link{BNDataset}
using MAP (Maximum A Posteriori) estimation.
}
\examples{
\dontrun{
## first create a BN and learn its structure from a dataset
dataset <- BNDataset("file.header", "file.data")
bn <- BN(dataset)
bn <- learn.structure(bn, dataset)
bn <- learn.params(bn, dataset, ess=1)
}
}
\seealso{
learn.network
}

