% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bomWater.R
\name{get_station_list}
\alias{get_station_list}
\title{Retrieve water observation stations}
\usage{
get_station_list(parameter_type, station_number, return_fields)
}
\arguments{
\item{parameter_type}{The parameter for the station request (e.g. Water
Course Discharge, Storage Level)}

\item{station_number}{Optional: a single or multiple vector of AWRC station
numbers.}

\item{return_fields}{Station details to be returned. By default the columns
returned are station name, number, ID, latitude and longitude. Can be
customised with a vector of parameters.}
}
\value{
With the default return fields, a tibble with columns station_name,
station_no, station_id, station_latitude, station_longitude.
}
\description{
`get_station_list` queries Water Data Online and returns station details.
Queries can be input with the desired `parameter_type` to find all the
stations on record. If you already have a vector of station numbers, you can
pass the vector to `station_number` and return the details of those
stations.
`return_fields` can be customised to return various data about the stations.
}
\examples{
# Get all Water Course Discharge Stations
get_station_list()
# Just the details for Cotter River at Gingera
get_station_list(station_number = "410730")
# Rainfall stations
get_station_list(parameter_type = "Rainfall")
}
\author{
Alexander Buzacott
}
