% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_station_locations.R
\name{update_station_locations}
\alias{update_station_locations}
\title{Update internal databases with latest BOM station metadata}
\usage{
update_station_locations()
}
\value{
Updated internal databases of \acronym{BOM} station locations and
\acronym{JSON} \acronym{URL}s
}
\description{
Download the latest station locations and metadata and update internal
databases that support the use of \code{\link{get_current_weather}}
\code{\link{get_ag_bulletin}} and \code{\link{get_historical}}.  There is no
need to use this unless you know that a station exists in BOM's database
that is not available in the databases distributed with \pkg{bomrang}. In
fact, for reproducibility purposes, users are discouraged from using this
function.
}
\details{
If \pkg{ASGS.foyer} is installed locally, this function will automatically
check and correct any invalid state values for stations located in Australia.
If \pkg{ASGS.foyer} is not installed, the function will update the internal
database without validating the state values for stations by reported
longitude/latitude location.
}
\examples{
\dontrun{
update_station_locations()
}
}
\references{
Station location and other metadata are sourced from the Australian Bureau of
Meteorology (\acronym{BOM}) webpage, Bureau of Meteorology Site Numbers:\cr
\url{http://www.bom.gov.au/climate/cdo/about/site-num.shtml}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
