% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometric_distribution.R
\name{geometric_distribution}
\alias{geometric_distribution}
\alias{geometric_pdf}
\alias{geometric_lpdf}
\alias{geometric_cdf}
\alias{geometric_lcdf}
\alias{geometric_quantile}
\title{Geometric Distribution Functions}
\usage{
geometric_pdf(x, prob)

geometric_lpdf(x, prob)

geometric_cdf(x, prob)

geometric_lcdf(x, prob)

geometric_quantile(p, prob)
}
\arguments{
\item{x}{quantile (non-negative integer)}

\item{prob}{probability of success (0 < prob < 1)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Geometric distribution.
}
\examples{
# Geometric distribution with probability of success prob = 0.5
geometric_pdf(3, 0.5)
geometric_lpdf(3, 0.5)
geometric_cdf(3, 0.5)
geometric_lcdf(3, 0.5)
geometric_quantile(0.5, 0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/dist_ref/dists/geometric_dist.html}{Boost Documentation} for more details on the mathematical background.
}
