% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomials.R
\name{jacobi_polynomials}
\alias{jacobi_polynomials}
\alias{jacobi}
\alias{jacobi_prime}
\alias{jacobi_double_prime}
\alias{jacobi_derivative}
\title{Jacobi Polynomials and Related Functions}
\usage{
jacobi(n, alpha, beta, x)

jacobi_prime(n, alpha, beta, x)

jacobi_double_prime(n, alpha, beta, x)

jacobi_derivative(n, alpha, beta, x, k)
}
\arguments{
\item{n}{Degree of the polynomial}

\item{alpha}{First parameter of the polynomial}

\item{beta}{Second parameter of the polynomial}

\item{x}{Argument of the polynomial}

\item{k}{Order of the derivative}
}
\value{
A single numeric value with the computed Jacobi polynomial, its derivative, or k-th derivative.
}
\description{
Functions to compute Jacobi polynomials, their derivatives, and related functions.
}
\examples{
# Jacobi polynomial P_2^(1, 2)(0.5)
jacobi(2, 1, 2, 0.5)
# Derivative of the Jacobi polynomial P_2^(1, 2)'(0.5)
jacobi_prime(2, 1, 2, 0.5)
# Second derivative of the Jacobi polynomial P_2^(1, 2)''(0.5)
jacobi_double_prime(2, 1, 2, 0.5)
# 3rd derivative of the Jacobi polynomial P_2^(1, 2)^(k)(0.5)
jacobi_derivative(2, 1, 2, 0.5, 3)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/sf_poly/jacobi.html}{Boost Documentation} for more details on the mathematical background.
}
