% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internalFunctions.R
\name{ssBetaPars}
\alias{ssBetaPars}
\title{Compute the sum of squares between the theoretical and observed quantiles of a beta distribution.}
\usage{
ssBetaPars(abPars, qLow, qUpp, alpha = 0.05)
}
\arguments{
\item{abPars}{The shape1 and shape2 parameters of the theoretical beta distribution.}

\item{qLow}{The observed lower quantile.}

\item{qUpp}{The observed upper quantile.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}
}
\value{
A single number, the sum of squares.
}
\description{
This is a helper function that compute the sum of squares between two theoretical and observed quantiles of a beta distribution (typically the lower and upper bounds of a confidence interval).
This function is for internal use to find the best-fit beta distribution for a given confidence interval.
}
\seealso{
\code{\link{identifyBetaPars}}, \code{\link{optim}}, \code{\link{qbeta}}
}
