

#' Box-Cox-Type Transformations for Linear and Logistic Models with Random Effects
#'
#' Box-Cox-type transformations for linear and logistic models with
#' random effects using non-parametric profile maximum likelihood
#' estimation. The main functions are \code{optim.boxcox()} for linear models with
#' random effects and \code{boxcoxtype()} for logistic models with
#' random effects.
#'
#' \tabular{ll}{ Package: \tab boxcoxmix\cr Type: \tab Package\cr Version: \tab
#' 0.28\cr Date: \tab 2020-09-17\cr License: \tab GPL (>=3)\cr }
#'
#' @name boxcoxmix-package
#' @aliases boxcoxmix boxcoxmix-package
#' @docType package
#' @author Amani Almohaimeed and Jochen Einbeck
#'
#' @references
#' Box G. and Cox D. (1964). An analysis of transformations. Journal of
#' the Royal Statistical Society. Series B (Methodological), pages 211-252.
#'
#' Aitkin, M. A., Francis, B., Hinde, J., and Darnell, R. (2009). Statistical
#' modelling in R. Oxford University Press Oxford.
#'
#' Jochen Einbeck, Ross Darnell and John Hinde (2014). npmlreg:
#' Nonparametric maximum likelihood estimation for random effect
#' models. R package version 0.46-1.
#'
#' R Core Team (2016). R: A language and environment for
#' statistical computing. R Foundation for Statistical Computing,
#' Vienna, Austria. URL https://www.R-project.org/.
#'
#'
#' Maintainer: Amani Almohaimeed <amani.almohaimeed@@gmail.com>
#' @keywords package
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
NULL



