#' Milk traits and corresponding mid-infrared spectra
#'
#' Data containing spectral measurements for 431 milk samples with various chemical and technological traits measures. Details can be found in Visentin et al. (2015) and McDermot et al. (2016).
#' @format Data of 431 dairy milk samples with variables split into a list of 3 data frames:
#' \describe{
#'	\item{\code{info}}{Information variables on the samples.}
#'	\item{\code{xMIR}}{531 spectral measurements in the mid-infrared region (predictors). Noisy water-regions have been removed.}
#'	\item{\code{yTraits}}{45 chemical and technological traits (responses); contains missing values.}
#' } 
#'
#'

#' @references McDermott, A., Visentin, G., De Marchi, M., Berry, D., Fenelon, M., O'connor, P., Kenny, O., and McParland, S. (2016). Prediction of individual milk proteins including free amino acids in bovine milk using mid-infrared spectroscopy and their correlations with milk processing characteristics. \emph{Journal of Dairy Science, 99(4):3171–3182.}
#'
#'	Visentin, G., McDermott, A., McParland, S., Berry, D., Kenny, O., Brodkorb, A., Fenelon, M., and De Marchi, M. (2015). Prediction of bovine milk technological traits from midinfrared spectroscopy analysis in dairy cows. \emph{Journal of Dairy Science}, 98(9):6620–6629.
#' @examples
#' data(milk_MIR, package="bplsr")
#' @docType data
#' @keywords datasets
#' @usage data(milk_MIR)
"milk_MIR"