% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{coef_circ.bpnr}
\alias{coef_circ.bpnr}
\title{Obtain the circular coefficients of a Bayesian circular regression model}
\usage{
\method{coef_circ}{bpnr}(object, type = "continuous", units = "radians")
}
\arguments{
\item{object}{a \code{bpnr object} obtained from the function
\code{\link{bpnr}}}

\item{type}{one of \code{c("continuous", "categorical")} to get either the
coefficients for the continuous or categorical predictor variables}

\item{units}{one of \code{c("degrees", "radians")} to get categorical
coefficients estimates and estimates for \code{$a_c$} in degrees or
radians.}
}
\value{
A matrix or list with posterior summaries of the circular
  coefficients in a Bayesian circular regression model.
}
\description{
Gives the coefficients tables of the circular coefficients for a Bayesian
circular regression model.
}
\examples{
library(bpnreg)
fit.Motor <- bpnr(pred.I = Phaserad ~ 1 + Cond, data = Motor,
its = 100, burn = 10, n.lag = 3)
coef_circ(fit.Motor)
coef_circ(fit.Motor, type = "categorical")

}
