% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRII.R
\name{negLoglikelihood}
\alias{negLoglikelihood}
\title{NegLoglikelihood function for Ordinal Models with 3 outcomes}
\usage{
negLoglikelihood(y, x, gammacp, beta, sigma, p)
}
\arguments{
\item{y}{dependent variable i.e. ordinal outcome values.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{gammacp}{row vector of cutpoints including -Inf and Inf.}

\item{beta}{column vector of coeffcients of dimension \eqn{(k x 1)}.}

\item{sigma}{scale factor, a scalar.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns the negative log-likelihood value.
}
\description{
This function computes the negative of the log-likelihood for quantile
ordinal model with 3 outcomes where the error is assumed to follow
an Asymmetric Laplace distribution.
}
\details{
Computes the negative of the log-likelihood for quantile
ordinal model with 3 outcomes where the error is assumed to follow
an asymmetric Laplace distribution.
}
\examples{
set.seed(101)
data("data25j3")
x <- data25j3$x
y <- data25j3$y
p <- 0.25
gammacp <- c(-Inf, 0, 4, Inf)
beta <- c(1.7201671, 1.9562172, 0.8334668)
sigma <- 0.9684741
ans <- negLoglikelihood(y, x, gammacp, beta, sigma, p)

# ans
#   231.8096

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.
}
\seealso{
likelihood maximization
}
