% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{deviance_or1}
\alias{deviance_or1}
\title{Deviance Information Criteria for ordinal quantile model
with more than 3 outcomes}
\usage{
deviance_or1(y, x, deltastore, burn, nsim, postMeanbeta, postMeandelta, beta, p)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{deltastore}{MCMC draws of \eqn{\delta}.}

\item{burn}{number of discarded MCMC iterations.}

\item{nsim}{total number of samples, including the burn-in.}

\item{postMeanbeta}{mean value of \eqn{\beta} obtained from MCMC draws.}

\item{postMeandelta}{mean value of \eqn{\delta} obtained from MCMC draws.}

\item{beta}{MCMC draw of coefficients, dimension is \eqn{(k x nsim)}.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components
\deqn{DIC = 2*avgdDeviance - devpostmean}
\deqn{pd = avgdDeviance - devpostmean}
\deqn{devpostmean = -2*(logLikelihood)}.
}
\description{
Function for computing the Deviance information criteria for ordinal quantile
model with more than 3 outcomes.
}
\details{
Deviance is \eqn{-2*(logLikelihood)} and has an important role in
statistical model comparison because of its relation with Kullback-Leibler
information criteria.
}
\examples{
set.seed(101)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
k <- dim(x)[2]
J <- dim(as.array(unique(y)))[1]
D0 <- 0.25*diag(J - 2)
output <- quantreg_or1(y = y,x = x, B0 = 10*diag(k), D0 = D0,
mcmc = 50, p = 0.25, tune = 1, display = FALSE)
mcmc <- 50
deltastore <- output$delta
burn <- 0.25*mcmc
nsim <- burn + mcmc
postMeanbeta <- output$postMeanbeta
postMeandelta <- output$postMeandelta
beta <- output$beta
deviance <- deviance_or1(y, x, deltastore, burn, nsim,
postMeanbeta, postMeandelta, beta, p = 0.25)

# DIC
#   1300.315
# pd
#   105.0351
# devpostmean
#   1090.245

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Spiegelhalter, D. J., Best, N. G., Carlin, B. P. and Linde, A. (2002).
“Bayesian Measures of Model Complexity and Fit.” Journal of the
Royal Statistical Society B, Part 4: 583-639. DOI: 10.1111/1467-9868.00353

Gelman, A., Carlin, J. B., Stern, H. S., and Rubin, D. B.
“Bayesian Data Analysis.” 2nd Edition, Chapman and Hall. DOI: 10.1002/sim.1856
}
\seealso{
decision criteria
}
