% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brQCA.R
\name{brQCA}
\alias{brQCA}
\title{Bootstrapped Recommendation}
\usage{
brQCA(
  qca.data,
  outcome = "OUT",
  type = "crisp",
  inclcut = "",
  ncut = 2,
  neg.out = FALSE,
  sim = 10,
  verbose = TRUE
)
}
\arguments{
\item{qca.data}{the QCA data frame.}

\item{outcome}{the outcome variable in the QCA data frame of causal conditions; \code{"OUT"} is the outcome variable for an application of QCA.}

\item{type}{of QCA application, \code{"crisp"} or \code{"fuzzy"} sets. Default set to \code{type = "crisp"}.}

\item{inclcut}{range of consistency scores for inclusion. If not specified, this defaults to \code{seq(from = 0.5, to = 1, by = 0.01)}.}

\item{ncut}{configurational n levels to simulate. Can be altered to give options for the range of minimum to maximum \code{ncut} value that the truth table yields, by naming the the truth table object (e.g. \code{truth}) and calling the minimum and maximum number of cases, using \code{ncut=min(truth$tt$n):max(truth$tt$n)} identified by the truth table. Default set to \code{ncut=2}.}

\item{neg.out}{[from QCA package] ``Logical, use negation of outcome (ignored if data is a truth table object).'' Default set to \code{neg.out=FALSE}.}

\item{sim}{number of simulations to run for each combination of parameters. The final number of simulations is \code{length(inclcut)*length(ncut)*sim*2}. Default set to \code{sim=10}.}

\item{verbose}{prints the system time used to run the simulation and the percent complete. Default set to \code{verbose=TRUE}.}
}
\value{
Significance levels reached (.10,.05, .01, .001) when specifying a combination of inclcut, ncut, and neg.out in a QCA model.
}
\description{
Provides recommendations for consistency score and configurational n thresholds to attain a desired level of confidence in a QCA algorithm application.
}
\examples{

qca.data <- rallies[,8:13]

\dontrun{
brQCA(qca.data,outcome="P",ncut=5,sim=1)
}
}
