% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPM.R
\name{SPM}
\alias{SPM}
\title{Perform between-group tests at each vertex for a given vertex measure}
\usage{
SPM(g, measure, outcome = measure, test = c("lm", "t.test", "wilcox.test"),
  alternative = c("two.sided", "less", "greater"), covars = NULL,
  permute = FALSE, N = 5000, alpha = 0.05)
}
\arguments{
\item{g}{A list of \code{igraph} graph objects for all subjects (if you have
multiple groups, you must concatenate the separate group lists)}

\item{measure}{A character string of the vertex measure of interest}

\item{outcome}{A character string of the name of the outcome variable; by
default, it is ignored}

\item{test}{A character string for the test to use, either 'lm', 't.test', or
'wilcox.test' (default: 'lm')}

\item{alternative}{Character string, whether to do a two- or one-sided test
(default: 'two.sided')}

\item{covars}{A \code{data.table} of covariates; needed if using \emph{lm}
(default: NULL)}

\item{permute}{Logical indicating whether or not to permute group labels
(default: FALSE)}

\item{N}{Integer; number of permutations to create (default: 5e3)}

\item{alpha}{Numeric; the significance level (default: 0.05)}
}
\value{
A list containing:
\item{g}{A graph with vertex attributes: \emph{size2} (t-statistic),
  \emph{size} (the t-stat transformed for visualization purposes), \emph{p}
  (equal to \eqn{1-p}), \emph{p.fdr} (equal to \eqn{1-p_{FDR}}, the
  FDR-adjusted p-value), \emph{beta} (the parameter estimate, if \emph{lm} or
  \emph{t.test} is used), \emph{se} (the standard error of \emph{beta}),
  \emph{df} (graph-level attribute of the degrees of freedom)}
\item{perm}{A list containing: \emph{null.dist} (the null distribution of
  maximum t-statistics), \emph{thresh} (the t-statistic value corresponding
  to \eqn{100 \times (1 - \alpha)}\% of the null distribution)}
}
\description{
This function takes a list of \code{igraph} graphs and performs either a
linear model, 2-sample t-test, or 2-sample Wilcoxon test at each vertex for a
given vertex measure (e.g. \emph{degree}).
}
\details{
You will need to provide a \code{data.table} of covariates, of which
\emph{Study.ID} and \emph{Group} need to be column names. Additionally, all
graphs must have a \emph{name} attribute (at the graph level) which matches
the \emph{Study.ID} for a given subject. If you do not provide covariates,
the code will pull group membership from the graphs' \emph{Group} graph
attributes and do a test of group differences. This function will then return
the p-value, t-statistic, and parameter estimate associated with the
\emph{Group} covariate.

If you would like to test whether a vertex attribute is associated with a
different outcome variable (for example, \emph{betweenness centrality} and
\emph{full-scale IQ}), then specify the relevant outcome variable in the
function call, and provide the data in the covariates table. This currently
only works for single-group data.

You may optionally do permutation testing by permuting the labels for subject
group. This is the same principle as that of Nichols & Holmes (2001) used in
voxelwise MRI analyses and implemented in FSL's \emph{randomise}.
}
\examples{
\dontrun{
g.diffs.btwn <- SPM(g=c(g.norm[[1]][[1]], g.norm[[2]][[1]]),
  measure='btwn.cent', test='wilcox.test')
g.diffs.btwn <- SPM(g=c(g[[1]][[5]], g[[2]][[5]]),
  measure='btwn.cent', test='lm', covars=covars.dti)
g.corrs.btwn.IQ <- SPM(g=g2, measure='btwn.cent', outcome='IQ', test='lm',
  covars=cbind(covars.dti, IQ))
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\references{
Nichols TE & Holmes AP (2001). \emph{Nonparametric permutation
  tests for functional neuroimaging: A primer with examples.} Human Brain
  Mapping, 15(1):1-25.
}

