% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBS.R
\name{NBS}
\alias{NBS}
\title{Network-based statistic for brain MRI data}
\usage{
NBS(A, covars, con.vec, X = NULL, p.init = 0.001, N = 1000,
  symmetric = FALSE, alternative = c("two.sided", "less", "greater"), ...)
}
\arguments{
\item{A}{Three-dimensional array of all subjects' connectivity matrices}

\item{covars}{A \code{data.table} of covariates}

\item{con.vec}{A numeric vector specifying the contrast of interest}

\item{X}{A numeric matrix (optional), if you would like to supply your own
design matrix (default: \code{NULL})}

\item{p.init}{Numeric; the initial p-value threshold (default: \code{0.001})}

\item{N}{Integer; the number of permutations (default: \code{1e3})}

\item{symmetric}{Logical indicating if input matrices are symmetric (default:
\code{FALSE})}

\item{alternative}{Character string, whether to do a two- or one-sided test
(default: \code{two.sided})}

\item{...}{Other arguments passed to \code{\link{brainGraph_GLM_design}}}
}
\value{
A list containing:
\item{g.nbs}{The \code{igraph} graph object based on the initial threshold}
\item{obs}{Integer vector of the observed connected component sizes}
\item{perm}{Integer vector of the permutation distribution of largest
  connected component sizes}
\item{p.perm}{Numeric vector of the permutation p-values for each component}
\item{p.init}{Numeric; the initial p-value threshold used}
}
\description{
Calculates the \emph{network-based statistic (NBS)}, which allows for
family-wise error (FWE) control over network data, introduced for brain MRI
data by Zalesky et al. Accepts a three-dimensional array of all subjects'
connectivity matrices and a \code{data.table} of covariates, and creates a
null distribution of the largest connected component size by permuting
subjects across groups. The covariates \code{data.table} must have (at least)
a \emph{Group} column.
}
\details{
The graph that is returned by this function will have a \code{t.stat} edge
attribute which is the t-statistic for that particular connection, along with
a \code{p} edge attribute, which is the p-value for that connection.
Additionally, each vertex will have a \code{p.nbs} attribute representing
\eqn{1 - } the p-value associated with that vertex's component.
}
\examples{
\dontrun{
max.comp.nbs <- NBS(A.norm.sub[[1]], covars.dti, N=5e3)
}
}
\references{
Zalesky A., Fornito A., Bullmore E.T. (2010) \emph{Network-based
  statistic: identifying differences in brain networks}. NeuroImage,
  53(4):1197-1207.
}
\seealso{
\code{\link{brainGraph_GLM_design}, \link{brainGraph_GLM_fit}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
