% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_brainGraph_multi.R
\name{plot_brainGraph_multi}
\alias{plot_brainGraph_multi}
\title{Save PNG of three views of a brain graph}
\usage{
plot_brainGraph_multi(g.list, groups = 1, N = 1, filename = "tmp.png",
  subgraph = NULL, main = NULL, ...)
}
\arguments{
\item{g.list}{A list of lists of \code{igraph} graph objects}

\item{groups}{An integer vector indicating which groups to plot; corresponds
to the first element of the list \code{g.list} (default: 1)}

\item{N}{Integer corresponding to the second element of the list
\code{g.list} (default: 1)}

\item{filename}{Character string of the filename of the PNG to be written
(default: 'tmp.png')}

\item{subgraph}{A list of character strings to (optionally) subset the
graph(s), possibly by multiple conditions (default: \code{NULL})}

\item{main}{A list of character strings to be placed in the main title of the
center plot for each group (default: \code{NULL})}

\item{...}{Other arguments passed to
\code{\link{plot_brainGraph}}}
}
\description{
This function will save a PNG file to disk containing three views (columns)
of a brain graph (from left-to-right): left sagittal, axial, and right
sagittal. The number of rows in the figure will equal the number of groups to
plot.
}
\details{
The function argument \code{N} tells the function to use the \code{N-th}
element of the input list \code{g.list} for each group. So, for example, if
\code{g.list} consists of lists of graphs for two groups, and \code{N} is 4,
then the plots for \code{g.list[[1]][[4]]} and \code{g.list[[2]][[4]]} will
be written to the file.

The \code{subgraph} argument can be used to apply one or more conditions for
subsetting the graph. If you would like multiple conditions, then it must be
a \code{list} variable that equals in length to the number of groups. For a
single group and multiple conditions, simply write e.g., \code{groups=c(1,
1)}. The \code{main} argument has the same rule except it controls the main
plot title, which appears in the \emph{axial} view along with the
\emph{Group} name.
}
\examples{
\dontrun{
plot_brainGraph_multi(g.hubs, groups=1:2, filename='Figure01_hubs.png',
  subgraph='N > 0', vertex.color='color.lobe', vertex.size=15,
  show.legend=TRUE, vertex.label.cex=1.5)
## Single group, different subgraphs for each plot
plot_brainGraph_multi(g, groups=c(1, 1), N=5, filename='5_6core.png',
  vertex.color='color.lobe', edge.color='color.lobe', vertex.label=NA,
  subgraph=list('coreness > 5', 'coreness > 6'),
  main=list('k-core 5', 'k-core 6'))
}
}
\seealso{
Other Plotting functions: \code{\link{plot.brainGraph_GLM}},
  \code{\link{plot.brainGraph_NBS}},
  \code{\link{plot.brainGraph_mediate}},
  \code{\link{plot.brainGraph_mtpc}},
  \code{\link{plot.brainGraph}},
  \code{\link{plot_brainGraph_gui}},
  \code{\link{plot_brainGraph_list}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
