% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_brainGraph_attributes.R
\name{Attributes}
\alias{Attributes}
\alias{set_brainGraph_attr}
\alias{xfm.weights}
\title{Set graph, vertex, and edge attributes common in MRI analyses}
\usage{
set_brainGraph_attr(g, type = c("observed", "random"),
  use.parallel = TRUE, A = NULL, xfm.type = c("1/w", "-log(w)",
  "1-w", "-log10(w/max(w))", "-log10(w/max(w)+1)"),
  clust.method = "louvain")

xfm.weights(g, xfm.type = c("1/w", "-log(w)", "1-w", "-log10(w/max(w))",
  "-log10(w/max(w)+1)"), invert = FALSE)
}
\arguments{
\item{g}{A graph object}

\item{type}{Character string indicating the type of graphs. Default:
\code{observed}}

\item{use.parallel}{Logical indicating whether to use \emph{foreach}.
Default: \code{TRUE}}

\item{A}{Numeric matrix; the (weighted) adjacency matrix, which can be used
for faster calculation of local efficiency. Default: \code{NULL}}

\item{xfm.type}{Character string specifying how to transform the weights.
Default: \code{1/w}}

\item{clust.method}{Character string indicating which method to use for
community detection. Default: \code{'louvain'}}

\item{invert}{Logical indicating whether or not to invert the transformation.
Default: \code{FALSE}}
}
\value{
A graph object with the following attributes:
  \item{Graph-level}{Density, connected component sizes, diameter, # of
    triangles, transitivity, average path length, assortativity, global &
    local efficiency, modularity, vulnerability, hub score, rich-club
    coefficient, # of hubs, edge asymmetry}
  \item{Vertex-level}{Degree, strength; betweenness, eigenvector, and
    leverage centralities; hubs; transitivity (local); k-core, s-core; local
    & nodal efficiency; color (community, lobe, component); membership
    (community, lobe, component); gateway and participation coefficients,
    within-module degree z-score; vulnerability; and coordinates (x, y, and
    z)}
  \item{Edge-level}{Color (community, lobe, component), edge betweenness,
    Euclidean distance (in mm), weight (if weighted)}

\code{xfm.weights} returns the same graph object, with transformed
  edge weights plus a graph attribute (\code{xfm.type}) recording the method
  of transformation
}
\description{
\code{set_brainGraph_attr} is a convenience function that sets a number of
graph, vertex, and edge attributes for a given graph object. Specifically, it
calculates measures that are common in MRI analyses of brain networks.
}
\details{
Including \code{type='random'} in the function call will reduce the number of
attributes calculated. It will only add graph-level attributes for:
clustering coefficient, characteristic path length, rich club coefficient,
global efficiency, and modularity.
}
\section{Negative edge weights}{

If there are any negative edge weights in the graph, several of the
distance-based metrics will \emph{not} be calculated, because they can throw
errors which is undesirable when processing a large dataset. The metrics are:
local and nodal efficiency, diameter, characteristic path length, and
hubness.
}

\section{Transforming edge weights}{

For distance-based measures, it is important to transform the edge weights so
that the \emph{strongest} connections are re-mapped to having the
\emph{lowest} weights. Then you may calculate e.g., the \emph{shortest path
length} which will include the strongest connections.

\code{xfm.type} allows you to choose from 5 options for transforming edge
weights when calculating distance-based metrics (e.g., shortest paths). There
is no \dQuote{best-practice} for choosing one over the other, but the reciprocal is
probably most common.
\describe{
  \item{\code{1/w}}{reciprocal (default)}
  \item{\code{-log(w)}}{the negative (natural) logarithm}
  \item{\code{1-w}}{subtract weights from 1}
  \item{\code{-log10(w/max(w))}}{negative (base-10) log of normalized
  weights}
  \item{\code{-log10(w/max(w)+1)}}{same as above, but add 1 before taking
    the log}
}

To transform the weights back to original values, specify \code{invert=TRUE}.
}

\section{Community detection}{

\code{clust.method} allows you to choose from any of the clustering
(community detection) functions available in \code{igraph}. These functions
begin with \code{cluster_}; the function argument should not include this
leading character string. There are a few possibilities, depending on the
value and the type of input graph:
\enumerate{
  \item By default, \code{louvain} is used, calling
    \code{\link[igraph]{cluster_louvain}}
  \item Uses \code{spinglass} if there are any negative edges and/or the
    selected method is \code{spinglass}
  \item Uses \code{walktrap} if there are any negative edge weights and any
    other method (besided \code{spinglass}) is selected
  \item Automatically transforms the edge weights if \code{edge_betweenness}
    is selected and the graph is weighted, because the algorithm considers
    edges as \emph{distances}
}
}

\seealso{
\code{\link[igraph]{components}}, \code{\link[igraph]{diameter}},
\code{\link[igraph]{centr_betw}}, \code{\link[igraph]{betweenness}},
\code{\link[igraph]{centr_eigen}}, \code{\link[igraph]{transitivity}},
\code{\link[igraph]{distances}}, \code{\link[igraph]{assortativity}},
\code{\link[igraph]{coreness}}, \code{\link[igraph]{communities}},
\code{\link[igraph]{knn}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
