% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_brainGraph.R
\name{plot.brainGraph}
\alias{plot.brainGraph}
\alias{plot_brainGraph}
\title{Plot a brain graph with a specific spatial layout}
\usage{
\method{plot}{brainGraph}(x, plane = c("axial", "sagittal", "circular"),
  hemi = c("both", "L", "R"), subgraph = NULL, show.legend = FALSE,
  rescale = FALSE, asp = 0, main = NULL, subt = "default",
  mni = TRUE, ...)

plot_brainGraph(x, plane = c("axial", "sagittal", "circular"),
  hemi = c("both", "L", "R"), subgraph = NULL, show.legend = FALSE,
  rescale = FALSE, asp = 0, main = NULL, subt = "default",
  mni = TRUE, ...)
}
\arguments{
\item{x}{A \code{brainGraph} graph object}

\item{plane}{Character string indicating which orientation to plot
(default: \code{'axial'})}

\item{hemi}{Character string indicating which hemisphere to plot (default:
\code{'both'})}

\item{subgraph}{Character string specifying an equation for vertices to plot
(default: \code{NULL})}

\item{show.legend}{Logical indicating whether or not to show a legend
(default: \code{FALSE})}

\item{rescale}{Logical, whether to rescale the coordinates (default:
\code{FALSE})}

\item{asp}{Numeric constant; the aspect ratio (default: 0)}

\item{main}{Character string; the main title (default: \code{NULL})}

\item{subt}{Character string; the subtitle (default: \code{default})}

\item{mni}{Logical indicating whether or not to plot over a slice of the
brain (default: \code{TRUE})}

\item{...}{Other parameters (passed to \code{\link[igraph]{plot.igraph}}).
See \code{\link[igraph]{igraph.plotting}} for details.}
}
\description{
\code{plot.brainGraph} plots a graph in which the spatial layout of the nodes
is important. The network itself is plotted over a brain MRI slice from the
MNI152 template if \code{mni=TRUE}.
}
\details{
With the argument \code{subgraph}, you can specify a simple logical equation
for which vertices to show. For example, \emph{'degree > 10'} will plot only
vertices with a \emph{degree} greater than 10. Combinations of \emph{AND}
(i.e., \code{&}) and \emph{OR} (i.e., \code{|}) are allowed.

To remove the subtitle at the bottom, simply specify \code{subt=NULL}.
}
\examples{
\dontrun{
plot(g[[1]], hemi='R')
plot(g[[1]], subgraph='degree > 10 | btwn.cent > 50')
}
}
\seealso{
Other Plotting functions: \code{\link{plot.brainGraph_GLM}},
  \code{\link{plot.brainGraph_NBS}},
  \code{\link{plot.brainGraph_mediate}},
  \code{\link{plot.brainGraph_mtpc}},
  \code{\link{plot_brainGraph_gui}},
  \code{\link{plot_brainGraph_list}},
  \code{\link{plot_brainGraph_multi}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Plotting functions}
