% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WBS.R
\name{sol.wbs}
\alias{sol.wbs}
\title{Solution path generation via the Wild Binary Segmentation method}
\usage{
sol.wbs(x, M = 10000, rand.intervals = TRUE, seed = NULL)
}
\arguments{
\item{x}{A numeric vector containing the data to be processed}

\item{M}{The maximum number of all data sub-samples at the beginning of the algorithm. The default is
\code{M = 10000}}

\item{rand.intervals}{When drawing the sub-intervals, whether to use a random or a fixed scheme. The default is \code{rand.intervals = TRUE}}

\item{seed}{If a random scheme is used, a random seed can be provided so that every time the same sets of random sub-intervals would be drawn. The default is \code{seed = NULL}, which means that this option is not taken}
}
\value{
An S3 object of class \code{cptpath}, which contains the following fields: 
\item{solutions.nested}{\code{TRUE}, i.e., the change-point outputs are nested}
\item{solution.path}{Locations of possible change-points in the mean of \code{x}, arranged in decreasing order of change-point importance}
\item{solution.set}{Empty list}
\item{x}{Input vector \code{x}}
\item{M}{Input parameter \code{M}}
\item{cands}{Matrix of dimensions length(\code{x}) - 1 by 4. The first two columns are (start, end)-points of the detection intervals of the corresponding possible change-point location in the third column. The fourth column is a measure of strength of the corresponding possible change-point. The order of the rows is the same as the order returned in \code{solution.path}}
\item{method}{The method used, which has value "wbs" here}
}
\description{
This function arranges all possible change-points in the mean of the input vector in the order of importance, via the Wild Binary Segmentation (WBS) method.
}
\details{
The Wild Binary Segmentation algorithm is described in 
"Wild binary segmentation for multiple change-point detection", P. Fryzlewicz (2014), The Annals of Statistics, 42: 2243--2281.
}
\examples{
r3 <- rnorm(1000) + c(rep(0,300), rep(2,200), rep(-4,300), rep(0,200))
sol.wbs(r3)
}
\references{
P. Fryzlewicz (2014). Wild binary segmentation for multiple change-point detection. \emph{The Annals of Statistics}, 42(6), 2243--2281.
}
\seealso{
\code{\link{sol.idetect}}, \code{\link{sol.not}}, \code{\link{sol.tguh}}, \code{\link{sol.wbs2}}
}
