% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_selic_rate.R
\name{get_selic_rate}
\alias{get_selic_rate}
\title{Get daily Brazilian SELIC rate data (annualized, base 252)}
\usage{
get_selic_rate(start_year, end_year, language = "eng")
}
\arguments{
\item{start_year}{Starting year (e.g., 2020)}

\item{end_year}{Ending year (e.g., 2024)}

\item{language}{Language for column names: "pt" for Portuguese or "eng" (default) for English}
}
\value{
A tibble with SELIC rate data between the selected years.
}
\description{
Downloads the daily SELIC rate series (ID 1178) from the Central Bank of Brazil’s
SGS (Time Series Management System) API. Returns a tidy data frame.
}
\examples{
\dontrun{
selic_data <- get_selic_rate(2020, 2024)
}
}
