% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_measures.R
\name{error_measures}
\alias{error_measures}
\title{Error Measures for Estimated Marginal Likelihood}
\usage{
error_measures(bridge_object)
}
\arguments{
\item{bridge_object}{an object of class \code{"bridge"} as returned from \code{\link{bridge_sampler}}.}
}
\value{
a list with the objects:
\itemize{
 \item \code{re2}: approximate relative mean squared error for marginal likelihood estimate.
 \item \code{cv}: coefficient of variation for marginal likelihood estimate (assumes that bridge estimate is unbiased).
 \item \code{percentage}: percentage error of marginal likelihood estimate.
}
}
\description{
Computes error measures for estimated marginal likelihood.
}
\details{
Computes approximate error measures for marginal likelihood bridge sampling estimates. Based on Fruehwirth-Schnatter (2004).
}
\note{
For examples, see \code{\link{bridge_sampler}} and the accompanying vignette: \cr \code{vignette("bridgesampling_example")}
}
\references{
Fruehwirth-Schnatter, S. (2004). Estimating marginal likelihoods for mixture and Markov switching models using bridge sampling techniques. \emph{The Econometrics Journal}, 7, 143-167. \url{http://dx.doi.org/10.1111/j.1368-423X.2004.00125.x}
}
\author{
Quentin F. Gronau
}
