% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_model.R
\name{brm_model}
\alias{brm_model}
\title{Basic MMRM}
\usage{
brm_model(data, formula, prior = NULL, ...)
}
\arguments{
\item{data}{A tidy data frame with one row per patient per discrete
time point.}

\item{formula}{An object of class \code{"brmsformula"} from \code{\link[=brm_formula]{brm_formula()}}
or \code{brms::brmsformula()}. Should include the full parameterization
of the model, including fixed effects, residual correlation,
and heterogeneity in the discrete-time-specific residual variance
components.}

\item{prior}{Either \code{NULL} for default priors
or a \code{"brmsprior"} object from \code{brms::prior()}.}

\item{...}{Arguments to \code{brms::brm()} other than \code{data}, \code{formula},
and \code{prior}.}
}
\value{
A fitted model object from \code{brms}.
}
\description{
Fit a basic MMRM model using \code{brms}.
}
\section{Parameterization}{

The formula is not the only factor
that determines the fixed effect parameterization.
The ordering of the categorical variables in the data,
as well as the \code{contrast} option in R, affect the
construction of the model matrix. To see the model
matrix that will ultimately be used in \code{\link[=brm_model]{brm_model()}},
run \code{\link[brms:make_standata]{brms::make_standata()}} and examine the \code{X} element
of the returned list. See the examples below for a
demonstration.
}

\examples{
if (identical(Sys.getenv("BRM_EXAMPLES", unset = ""), "true")) {
set.seed(0L)
data <- brm_data(
  data = brm_simulate_simple()$data,
  outcome = "response",
  role = "response",
  group = "group",
  time = "time",
  patient = "patient",
  reference_group = "group_1",
  reference_time = "time_1"
)
formula <- brm_formula(
  data = data,
  baseline = FALSE,
  baseline_time = FALSE
)
# Optional: set the contrast option, which determines the model matrix.
options(contrasts = c(unordered = "contr.SAS", ordered = "contr.poly"))
# See the fixed effect parameterization you get from the data:
head(brms::make_standata(formula = formula, data = data)$X)
# Specify a different contrast method to use an alternative
# parameterization when fitting the model with brm_model():
options(
  contrasts = c(unordered = "contr.treatment", ordered = "contr.poly")
)
# different model matrix than before:
head(brms::make_standata(formula = formula, data = data)$X)
tmp <- utils::capture.output(
  suppressMessages(
    suppressWarnings(
      model <- brm_model(
        data = data,
        formula = formula,
        chains = 1,
        iter = 100,
        refresh = 0
      )
    )
  )
)
# The output model is a brms model fit object.
model
# The `prior_summary()` function shows the full prior specification
# which reflects the fully realized fixed effects parameterization.
brms::prior_summary(model)
}
}
\seealso{
Other models: 
\code{\link{brm_formula}()}
}
\concept{models}
