% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{InvGaussian}
\alias{InvGaussian}
\alias{dinv_gaussian}
\alias{pinv_gaussian}
\alias{rinv_gaussian}
\title{The Inverse Gaussian Distribution}
\usage{
dinv_gaussian(x, mu = 1, shape = 1, log = FALSE)

pinv_gaussian(q, mu = 1, shape = 1, lower.tail = TRUE, log.p = FALSE)

rinv_gaussian(n, mu = 1, shape = 1)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{mu}{Vector of locations.}

\item{shape}{Vector of shapes.}

\item{log}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{lower.tail}{Logical; If \code{TRUE} (default), return P(X <= x). 
Else, return P(X > x) .}

\item{log.p}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{n}{Number of samples to draw from the distribution.}
}
\description{
Density, distribution function, and random generation 
for the inverse Gaussian distribution with location \code{mu}, 
and shape \code{shape}.
}
\details{
See \code{vignette("brms_families")} for details
on the parameterization.
}
