% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{pp_average.brmsfit}
\alias{pp_average.brmsfit}
\alias{pp_average}
\title{Posterior predictive samples averaged across models}
\usage{
\method{pp_average}{brmsfit}(x, ..., weights = "loo", method = c("predict",
  "fitted", "residuals"), newdata = NULL, re_formula = NULL,
  allow_new_levels = FALSE, sample_new_levels = "uncertainty",
  new_objects = list(), incl_autocor = TRUE, resp = NULL,
  nsamples = NULL, sort = FALSE, nug = NULL, summary = TRUE,
  robust = FALSE, probs = c(0.025, 0.975), more_args = NULL,
  control = NULL)

pp_average(x, ...)
}
\arguments{
\item{x}{A \code{brmsfit} object.}

\item{...}{More \code{brmsfit} objects.}

\item{weights}{Name of the criterion to compute weights from. 
Should be one of \code{"loo"} (default), 
\code{"waic"}, \code{"kfold"}, or \code{"bridge"} 
(log marginal likelihood). Alternatively, a numeric
vector with pre-specified weights.}

\item{method}{Type of predictions to average. Should be one of 
\code{"predict"} (default), \code{"fitted"}, or \code{"residuals"}.}

\item{newdata}{An optional data.frame for which to evaluate predictions.
If \code{NULL} (default), the original data of the model is used.}

\item{re_formula}{formula containing group-level effects 
to be considered in the prediction. 
If \code{NULL} (default), include all group-level effects; 
if \code{NA}, include no group-level effects.}

\item{allow_new_levels}{A flag indicating if new
levels of group-level effects are allowed 
(defaults to \code{FALSE}). 
Only relevant if \code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels 
for grouping factors specified in \code{re_formula}.
This argument is only relevant if \code{newdata} is provided and 
\code{allow_new_levels} is set to \code{TRUE}.
If \code{"uncertainty"} (default), include group-level uncertainty
in the predictions based on the variation of the existing levels. 
If \code{"gaussian"}, sample new levels from the (multivariate) 
normal distribution implied by the group-level standard deviations 
and correlations. This options may be useful for conducting 
Bayesian power analysis. 
If \code{"old_levels"}, directly sample new levels from the
existing levels.}

\item{new_objects}{A named \code{list} of objects containing 
new data, which cannot be passed via argument \code{newdata}.
Currently, only required for objects passed to 
\code{\link[brms:cor_sar]{cor_sar}} and 
\code{\link[brms:cor_fixed]{cor_fixed}}.}

\item{incl_autocor}{A flag indicating if ARMA autocorrelation
parameters should be included in the predictions. Defaults to 
\code{TRUE}. Setting it to \code{FALSE} will not affect other 
correlation structures such as \code{\link[brms:cor_bsts]{cor_bsts}},
or \code{\link[brms:cor_fixed]{cor_fixed}}.}

\item{resp}{Optional names of response variables.
If specified, fitted values of these response variables are returned.}

\item{nsamples}{Positive integer indicating how many 
posterior samples should be used. 
If \code{NULL} (the default) all samples are used.
Ignored if \code{subset} is not \code{NULL}.}

\item{sort}{Logical. Only relevant for time series models. 
Indicating whether to return predicted values in the original 
order (\code{FALSE}; default) or in the order of the 
time series (\code{TRUE}).}

\item{nug}{Small positive number for Gaussian process terms only. 
For numerical reasons, the covariance matrix of a Gaussian 
process might not be positive definite. Adding a very small 
number to the matrix's diagonal often solves this problem. 
If \code{NULL} (the default), \code{nug} is chosen internally.}

\item{summary}{Should summary statistics 
 (i.e. means, sds, and 95\% intervals) be returned
instead of the raw values? Default is \code{TRUE}.}

\item{robust}{If \code{FALSE} (the default) the mean is used as 
the measure of central tendency and the standard deviation as 
the measure of variability. If \code{TRUE}, the median and the 
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile} 
function. Only used if \code{summary} is \code{TRUE}.}

\item{more_args}{Optional \code{list} of further arguments 
passed to the function specified in \code{method}.}

\item{control}{Optional \code{list} of further arguments 
passed to the function specified in \code{weights}.}
}
\value{
Same as the output of the method specified 
  in argument \code{method}.
}
\description{
Compute posterior predictive samples averaged across models.
Weighting can be done in various ways, for instance using
Akaike weights based on information criteria or 
marginal likelihoods.
}
\examples{
\dontrun{
# model with 'treat' as predictor
fit1 <- brm(rating ~ treat + period + carry, data = inhaler)
summary(fit1)

# model without 'treat' as predictor
fit2 <- brm(rating ~ period + carry, data = inhaler)
summary(fit2)

# compute model-averaged predicted values
(df <- unique(inhaler[, c("treat", "period", "carry")]))
pp_average(fit1, fit2, newdata = df)

# compute model-averaged fitted values
pp_average(fit1, fit2, method = "fitted", newdata = df)
}

}
