% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-re.R
\name{mmc}
\alias{mmc}
\title{Multi-Membership Covariates}
\usage{
mmc(...)
}
\arguments{
\item{...}{One or more terms containing covariates 
corresponding to the grouping levels specified in \code{\link{mm}}.}
}
\value{
A matrix with covariates as columns.
}
\description{
Specify covariates that vary over different levels 
of multi-membership grouping factors thus requiring
special treatment. This function is almost solely useful,
when called in combination with \code{\link{mm}}. 
Outside of multi-membership terms it will behave
very much like \code{\link{cbind}}.
}
\examples{
\dontrun{
# simulate some data
dat <- data.frame(
  y = rnorm(100), x1 = rnorm(100), x2 = rnorm(100),
  g1 = sample(1:10, 100, TRUE), g2 = sample(1:10, 100, TRUE)
)

# multi-membership model with level specific covariate values
dat$xc <- (dat$x1 + dat$x2) / 2 
fit <- brm(y ~ xc + (1 + mmc(x1, x2) | mm(g1, g2)), data = dat)
summary(fit)
}

}
\seealso{
\code{\link{mm}}
}
