% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_moment_match.R
\name{loo_moment_match.brmsfit}
\alias{loo_moment_match.brmsfit}
\alias{loo_moment_match}
\title{Moment matching for efficient approximate leave-one-out cross-validation}
\usage{
\method{loo_moment_match}{brmsfit}(
  x,
  loo,
  k_threshold = 0.7,
  newdata = NULL,
  resp = NULL,
  check = TRUE,
  recompile = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{brmsfit}.}

\item{loo}{An object of class \code{loo} originally created from \code{x}.}

\item{k_threshold}{The Pareto \eqn{k} threshold for which observations
moment matching is applied. Defaults to \code{0.7}.
See \code{\link[loo:pareto-k-diagnostic]{pareto_k_ids}}
for more details.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{check}{Logical; If \code{TRUE} (the default), some checks
check are performed if the \code{loo} object was generated
from the \code{brmsfit} object passed to argument \code{fit}.}

\item{recompile}{Logical, indicating whether the Stan model should be
recompiled. This may be necessary if you are running moment matching on
another machine than the one used to fit the model. No recompilation
is done by default.}

\item{...}{Further arguments passed to the underlying methods.
Additional arguments initially passed to \code{\link{loo}},
for example, \code{newdata} or \code{resp} need to be passed
again to \code{loo_moment_match} in order for the latter
to work correctly.}
}
\value{
An updated object of class \code{loo}.
}
\description{
Moment matching for efficient approximate leave-one-out cross-validation
(LOO-CV). See \code{\link[loo:loo_moment_match]{loo_moment_match}}
for more details.
}
\details{
The moment matching algorithm requires draws of all variables
  defined in Stan's \code{parameters} block to be saved. Otherwise
  \code{loo_moment_match} cannot be computed. Thus, please set
  \code{save_pars = save_pars(all = TRUE)} in the call to \code{\link{brm}},
  if you are planning to apply \code{loo_moment_match} to your models.
}
\examples{
\dontrun{
fit1 <- brm(count ~ zAge + zBase * Trt + (1|patient),
            data = epilepsy, family = poisson(),
            save_pars = save_pars(all = TRUE))

# throws warning about some pareto k estimates being too high
(loo1 <- loo(fit1))
(mmloo1 <- loo_moment_match(fit1, loo = loo1))
}

}
\references{
Paananen, T., Piironen, J., Buerkner, P.-C., Vehtari, A. (2021).
  Implicitly Adaptive Importance Sampling. Statistics and Computing.
}
