% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo-helpers.R
\name{loo_compare.brmsfit}
\alias{loo_compare.brmsfit}
\alias{loo_compare}
\title{Model comparison with the \pkg{loo} package}
\usage{
\method{loo_compare}{brmsfit}(x, ..., criterion = c("loo", "waic",
  "kfold"), model_names = NULL)
}
\arguments{
\item{x}{A \code{brmsfit} object.}

\item{...}{More \code{brmsfit} objects.}

\item{criterion}{The name of the criterion to be extracted 
from \code{brmsfit} objects.}

\item{model_names}{If \code{NULL} (the default) will use model names 
derived from deparsing the call. Otherwise will use the passed 
values as model names.}
}
\value{
An object of class "\code{compare.loo}".
}
\description{
For more details see \code{\link[loo:loo_compare]{loo_compare}}.
}
\details{
All \code{brmsfit} objects should contain precomputed
  criterion objects. See \code{\link{add_criterion}} for more help.
}
\examples{
\dontrun{
# model with population-level effects only
fit1 <- brm(rating ~ treat + period + carry,
            data = inhaler)
fit1 <- add_criterion(fit1, "waic")

# model with an additional varying intercept for subjects
fit2 <- brm(rating ~ treat + period + carry + (1|subject),
            data = inhaler)
fit2 <- add_criterion(fit2, "waic")

# compare both models
loo_compare(fit1, fit2, criterion = "waic")
}

}
