% Generated by roxygen2 (4.0.0): do not edit by hand
\name{attachfile}
\alias{attachfile}
\title{Attach a workspace}
\usage{
attachfile(i, stem = "perm", end = ".RData", fixdig = TRUE,
  verbose = TRUE)
}
\arguments{
\item{i}{An integer or character string.}

\item{stem}{Initial part of name.}

\item{end}{Last part of name.}

\item{fixdig}{If TRUE and \code{i} is an integer < 10, append a 0 to i.}

\item{verbose}{If true, print a message if the file can't be loaded.}
}
\value{
TRUE/FALSE according to whether the file exists (and so the function worked).
}
\description{
Attach a workspace for a directory name of a particular form.
}
\details{
This function attaches the workspace \code{paste(stem,i,end,sep="")},
  possibly adding a 0 before i if i < 10.
}
\examples{
\dontrun{for(i in 1:5) attachfile(i)}
}
\author{
Karl W Broman \email{kbroman@biostat.wisc.edu}
}
\seealso{
\code{\link{loadwork}},
  \code{\link{attachwork}}, \code{\link{loadfile}}
}
\keyword{IO}

