% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_get_pairwise_contrasts.R
\name{model_get_pairwise_contrasts}
\alias{model_get_pairwise_contrasts}
\title{Get pairwise comparison of the levels of a categorical variable}
\usage{
model_get_pairwise_contrasts(
  model,
  variables,
  pairwise_reverse = TRUE,
  conf.level = 0.95,
  emmeans_args = list()
)
}
\arguments{
\item{model}{a model object}

\item{variables}{names of variables to add pairwise contrasts}

\item{pairwise_reverse}{determines whether to use \code{"pairwise"} (if \code{TRUE})
or \code{"revpairwise"} (if \code{FALSE}), see \code{\link[emmeans:contrast]{emmeans::contrast()}}}

\item{conf.level}{level of confidence for confidence intervals}

\item{emmeans_args}{list of additional parameter to pass to
\code{\link[emmeans:emmeans]{emmeans::emmeans()}} when computing pairwise contrasts}
}
\description{
It is computed with \code{\link[emmeans:emmeans]{emmeans::emmeans()}}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (.assert_package("emmeans", boolean = TRUE)) {
  mod <- lm(Sepal.Length ~ Species, data = iris)
  mod \%>\% model_get_pairwise_contrasts(variables = "Species")
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other model_helpers: 
\code{\link{model_compute_terms_contributions}()},
\code{\link{model_get_assign}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_model}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_n}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_response}()},
\code{\link{model_get_terms}()},
\code{\link{model_get_weights}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
